/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.AbstractO2AuthenticationFilter;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import org.glassfish.jersey.server.ContainerRequest;
import org.hibernate.Session;

@Priority(value=1000)
public final class O2ClientBodyFilter
extends AbstractO2AuthenticationFilter {
    private final Boolean permitPrivate;
    private final Boolean permitPublic;

    public O2ClientBodyFilter(Provider<ContainerRequest> requestProvider, Provider<Session> sessionProvider, Boolean permitPrivate, Boolean permitPublic) {
        super(requestProvider, sessionProvider);
        this.permitPrivate = permitPrivate;
        this.permitPublic = permitPublic;
    }

    public void filter(ContainerRequestContext context) {
        String rawClientSecret;
        String method = context.getMethod();
        if (!method.equals("POST")) {
            return;
        }
        if (!context.getMediaType().equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            return;
        }
        ContainerRequest request = this.getRequest();
        request.bufferEntity();
        Form body = (Form)request.readEntity(Form.class);
        MultivaluedMap data = body.asMap();
        List rawClientIds = (List)data.getOrDefault((Object)"client_id", Collections.emptyList());
        List rawClientSecrets = (List)data.getOrDefault((Object)"client_secret", Collections.emptyList());
        if (rawClientIds.size() > 1 || rawClientSecrets.size() > 1) {
            throw new BadRequestException();
        }
        if (rawClientIds.size() == 0) {
            return;
        }
        String rawClientId = Optional.of(rawClientIds).map(l -> (String)l.get(0)).orElse(null);
        Map.Entry<BigInteger, String> creds = this.convertCredentials(rawClientId, rawClientSecret = (String)Optional.of(rawClientSecrets).filter((? super T l) -> l.size() == 1).map(l -> (String)l.get(0)).orElse(null));
        if (creds == null) {
            throw new BadRequestException();
        }
        Client client = Optional.of(creds.getKey()).map(id -> (Client)((Object)((Object)this.getSession().find(Client.class, id)))).filter((? super T c) -> Objects.equals(c.getClientSecret(), creds.getValue())).orElseThrow(RFC6749.AccessDeniedException::new);
        if (!client.isPublic().equals(this.permitPublic) && !client.isPrivate().equals(this.permitPrivate)) {
            throw new RFC6749.AccessDeniedException();
        }
        this.setPrincipal(new O2Principal(client));
    }
}

