/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import com.google.common.base.Strings;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.AbstractO2AuthenticationFilter;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import org.glassfish.jersey.server.ContainerRequest;
import org.hibernate.Session;

@Priority(value=1000)
public final class O2ClientBasicAuthFilter
extends AbstractO2AuthenticationFilter {
    private static final Pattern BASIC = Pattern.compile("^Basic ([0-9a-zA-Z]+={0,2})$", 2);
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public O2ClientBasicAuthFilter(Provider<ContainerRequest> requestProvider, Provider<Session> sessionProvider) {
        super(requestProvider, sessionProvider);
    }

    public void filter(ContainerRequestContext request) {
        Matcher authHeader = Optional.ofNullable(request.getHeaderString("Authorization")).map(String::trim).map(BASIC::matcher).filter(Matcher::matches).orElse(null);
        if (authHeader == null) {
            return;
        }
        Map.Entry creds = Optional.ofNullable(authHeader.group(1)).map(s -> new String(DECODER.decode((String)s), UTF8)).map(Strings::nullToEmpty).filter((? super T s) -> s.contains(":")).map(s -> s.split(":", 2)).map(s -> this.convertCredentials(s[0], s[1])).filter((? super T t) -> Objects.nonNull(t.getValue())).orElseThrow(BadRequestException::new);
        Client client = Optional.of(creds.getKey()).map(id -> (Client)((Object)((Object)this.getSession().find(Client.class, id)))).filter((? super T c) -> ((String)creds.getValue()).equals(c.getClientSecret())).orElseThrow(RFC6749.AccessDeniedException::new);
        this.setPrincipal(new O2Principal(client));
    }
}

