/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import java.math.BigInteger;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.AbstractO2AuthenticationFilter;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.glassfish.jersey.server.ContainerRequest;
import org.hibernate.Session;

@Priority(value=1000)
public final class O2BearerTokenFilter
extends AbstractO2AuthenticationFilter {
    private static final Pattern BEARER = Pattern.compile("^Bearer ([a-f0-9]{32})$", 2);
    private final Boolean permitPrivate;
    private final Boolean permitPublic;

    public O2BearerTokenFilter(Provider<ContainerRequest> requestProvider, Provider<Session> sessionProvider, boolean permitPrivate, boolean permitPublic) {
        super(requestProvider, sessionProvider);
        this.permitPrivate = permitPrivate;
        this.permitPublic = permitPublic;
    }

    public void filter(ContainerRequestContext request) {
        Matcher authHeader = Optional.ofNullable(request.getHeaderString("Authorization")).map(String::trim).map(BEARER::matcher).filter(Matcher::matches).orElse(null);
        if (authHeader == null) {
            return;
        }
        BigInteger bigId = Optional.ofNullable(authHeader.group(1)).map(IdUtil::fromString).orElseThrow(BadRequestException::new);
        OAuthToken token = Optional.of(bigId).map(id -> (OAuthToken)this.getSession().find(OAuthToken.class, id)).filter((? super T t) -> t.getTokenType().equals((Object)OAuthTokenType.Bearer)).filter((? super T t) -> !t.isExpired()).orElseThrow(RFC6749.AccessDeniedException::new);
        Client c = token.getClient();
        if (!c.isPublic().equals(this.permitPublic) && !c.isPrivate().equals(this.permitPrivate)) {
            throw new RFC6749.AccessDeniedException();
        }
        this.setPrincipal(new O2Principal(token));
    }
}

