/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2SecurityContext;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.glassfish.jersey.server.ContainerRequest;
import org.hibernate.Session;

public abstract class AbstractO2AuthenticationFilter
implements ContainerRequestFilter {
    private final Provider<ContainerRequest> requestProvider;
    private final Provider<Session> sessionProvider;

    public AbstractO2AuthenticationFilter(Provider<ContainerRequest> requestProvider, Provider<Session> sessionProvider) {
        this.sessionProvider = sessionProvider;
        this.requestProvider = requestProvider;
    }

    final Session getSession() {
        return (Session)this.sessionProvider.get();
    }

    final ContainerRequest getRequest() {
        return (ContainerRequest)this.requestProvider.get();
    }

    final SecurityContext getSecurityContext() {
        return this.getRequest().getSecurityContext();
    }

    protected final void setPrincipal(O2Principal newPrincipal) {
        SecurityContext context = this.getSecurityContext();
        O2Principal principal = Optional.ofNullable(context).map(c -> newPrincipal.merge(c.getUserPrincipal())).orElse(newPrincipal);
        O2SecurityContext newContext = new O2SecurityContext(principal);
        this.getRequest().setSecurityContext((SecurityContext)newContext);
    }

    protected final Map.Entry<BigInteger, String> convertCredentials(String rawId, String rawSecret) {
        try {
            String secret = Strings.emptyToNull((String)rawSecret);
            return Optional.ofNullable(rawId).map(IdUtil::fromString).map(id -> new AbstractMap.SimpleEntry<BigInteger, String>((BigInteger)id, secret)).orElse(null);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

