/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn;

import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthScheme;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.util.ObjectUtil;

public final class O2Principal
implements Principal {
    private final Client contextClient;
    private final OAuthToken oAuthToken;

    public O2Principal() {
        this(null, null);
    }

    public O2Principal(Client client) {
        this(client, null);
    }

    public O2Principal(OAuthToken token) {
        this(Optional.ofNullable(token).map(OAuthToken::getClient).orElse(null), token);
    }

    private O2Principal(Client client, OAuthToken token) {
        this.contextClient = Optional.ofNullable(client).filter(c -> !Objects.isNull(c.getId())).orElse(null);
        this.oAuthToken = Optional.ofNullable(token).filter(t -> !Objects.isNull(t.getId())).orElse(null);
    }

    public OAuthToken getOAuthToken() {
        return this.oAuthToken;
    }

    protected <T extends AbstractEntity> T sameOrOne(T left, T right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (!left.equals(right)) {
            throw new RFC6749.AccessDeniedException();
        }
        return left;
    }

    @Override
    public String getName() {
        if (!Objects.isNull((Object)this.contextClient)) {
            return this.contextClient.getName();
        }
        return null;
    }

    @Override
    public boolean implies(Subject subject) {
        return false;
    }

    public String getScheme() {
        if (this.oAuthToken == null) {
            return Optional.ofNullable(this.contextClient).map(c -> c.isPublic() != false ? O2AuthScheme.ClientPublic : O2AuthScheme.ClientPrivate).orElse(O2AuthScheme.None).toString();
        }
        return O2AuthScheme.BearerToken.toString();
    }

    public Client getContext() {
        return this.contextClient;
    }

    public O2Principal merge(Principal newPrincipal) {
        O2Principal principal = ObjectUtil.safeCast((Object)newPrincipal, O2Principal.class).orElse(null);
        if (Objects.isNull(principal)) {
            return new O2Principal(this.contextClient, this.oAuthToken);
        }
        O2Principal merged = new O2Principal(this.sameOrOne(this.contextClient, principal.contextClient), this.sameOrOne(this.oAuthToken, principal.oAuthToken));
        long validSchemes = Stream.of(this.getScheme(), principal.getScheme()).map(O2AuthScheme::valueOf).distinct().filter(s -> !s.equals((Object)O2AuthScheme.None)).count();
        if (validSchemes > 1L) {
            throw new RFC6749.AccessDeniedException();
        }
        return merged;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ObjectUtil.safeCast((Object)o, O2Principal.class).filter(p -> com.google.common.base.Objects.equal((Object)this.getScheme(), (Object)p.getScheme())).filter(p -> com.google.common.base.Objects.equal((Object)((Object)this.getContext()), (Object)((Object)p.getContext()))).filter(p -> com.google.common.base.Objects.equal((Object)this.getOAuthToken(), (Object)p.getOAuthToken())).isPresent();
    }

    @Override
    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getScheme(), this.getContext(), this.getOAuthToken()});
    }
}

