/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2BearerToken;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2BearerTokenFilter;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2ClientBasicAuthFilter;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2ClientBodyFilter;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.O2ClientQueryParameterFilter;
import net.krotscheck.kangaroo.authz.oauth2.authn.authz.O2AuthorizationFilter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.hibernate.Session;

public final class O2AuthDynamicFeature
implements DynamicFeature {
    private final Provider<Session> sessionProvider;
    private final Provider<ContainerRequest> requestProvider;

    @Inject
    O2AuthDynamicFeature(Provider<Session> sessionProvider, Provider<ContainerRequest> requestProvider) {
        this.sessionProvider = sessionProvider;
        this.requestProvider = requestProvider;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Boolean client = am.isAnnotationPresent(O2Client.class);
        Boolean token = am.isAnnotationPresent(O2BearerToken.class);
        if (client.booleanValue()) {
            O2Client clientAT = (O2Client)am.getAnnotation(O2Client.class);
            Boolean permitPrivate = clientAT.permitPrivate();
            Boolean permitPublic = clientAT.permitPublic();
            if (permitPublic.booleanValue()) {
                configuration.register((Object)new O2ClientQueryParameterFilter(this.requestProvider, this.sessionProvider));
            }
            if (permitPrivate.booleanValue()) {
                configuration.register((Object)new O2ClientBasicAuthFilter(this.requestProvider, this.sessionProvider));
            }
            configuration.register((Object)new O2ClientBodyFilter(this.requestProvider, this.sessionProvider, permitPrivate, permitPublic));
        }
        if (token.booleanValue()) {
            O2BearerToken tokenAT = (O2BearerToken)am.getAnnotation(O2BearerToken.class);
            configuration.register((Object)new O2BearerTokenFilter(this.requestProvider, this.sessionProvider, tokenAT.permitPrivate(), tokenAT.permitPublic()));
        }
        if (client.booleanValue() || token.booleanValue()) {
            configuration.register((Object)new O2AuthorizationFilter());
        }
    }
}

