/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.util;

import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractClientUri;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static void validateResponseType(Client client, String responseType) {
        if (client != null) {
            if (ClientType.Implicit.equals((Object)client.getType()) && "token".equals(responseType)) {
                return;
            }
            if (ClientType.AuthorizationGrant.equals((Object)client.getType()) && "code".equals(responseType)) {
                return;
            }
        }
        throw new RFC6749.UnsupportedResponseTypeException();
    }

    public static URI requireValidRedirect(URI redirect, List<ClientRedirect> redirects) {
        URI validRedirect = ValidationUtil.validateRedirect(redirect, redirects);
        if (validRedirect == null) {
            throw new RFC6749.InvalidRequestException();
        }
        return validRedirect;
    }

    public static URI requireValidRedirect(String redirect, List<ClientRedirect> redirects) {
        URI validRedirect = ValidationUtil.validateRedirect(redirect, redirects);
        if (validRedirect == null) {
            throw new RFC6749.InvalidRequestException();
        }
        return validRedirect;
    }

    public static URI requireValidRedirect(String redirect, Set<URI> redirects) {
        URI validRedirect = ValidationUtil.validateRedirect(redirect, redirects);
        if (validRedirect == null) {
            throw new RFC6749.InvalidRequestException();
        }
        return validRedirect;
    }

    public static URI validateRedirect(URI redirect, List<ClientRedirect> redirects) {
        if (redirect == null) {
            return ValidationUtil.validateRedirect((String)null, redirects);
        }
        return ValidationUtil.validateRedirect(redirect.toString(), redirects);
    }

    public static URI validateRedirect(String redirect, List<ClientRedirect> redirects) {
        Set<URI> redirectUris = redirects.stream().map(AbstractClientUri::getUri).collect(Collectors.toSet());
        return ValidationUtil.validateRedirect(redirect, redirectUris);
    }

    public static URI validateRedirect(URI redirect, Set<URI> redirects) {
        if (redirect == null) {
            return ValidationUtil.validateRedirect((String)null, redirects);
        }
        return ValidationUtil.validateRedirect(redirect.toString(), redirects);
    }

    public static URI validateRedirect(String redirect, Set<URI> redirects) {
        URI redirectUri;
        if (redirects.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)redirect)) {
            if (redirects.size() == 1) {
                URI[] redirectArray = redirects.toArray(new URI[redirects.size()]);
                return redirectArray[0];
            }
            return null;
        }
        try {
            redirectUri = UriBuilder.fromUri((String)redirect).build(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        MultivaluedMap<String, String> params = ValidationUtil.extractParams(redirectUri);
        HashSet keySet = new HashSet(params.keySet());
        params.keySet().retainAll(keySet);
        block2: for (URI test : redirects) {
            if (!test.getScheme().equals(redirectUri.getScheme()) || !test.getHost().equals(redirectUri.getHost()) || test.getPort() != redirectUri.getPort() || !test.getPath().equals(redirectUri.getPath())) continue;
            MultivaluedMap<String, String> testParams = ValidationUtil.extractParams(test);
            keySet.addAll(testParams.keySet());
            for (Map.Entry entry : testParams.entrySet()) {
                if (((List)params.get(entry.getKey())).containsAll((Collection)entry.getValue())) continue;
                continue block2;
            }
            return redirectUri;
        }
        return null;
    }

    private static MultivaluedMap<String, String> extractParams(URI redirectUri) {
        MultivaluedHashMap results = new MultivaluedHashMap();
        for (NameValuePair pair : URLEncodedUtils.parse((URI)redirectUri, (String)"UTF-8")) {
            results.add((Object)pair.getName(), (Object)pair.getValue());
        }
        return results;
    }

    public static SortedMap<String, ApplicationScope> validateScope(String[] requestedScopes, SortedMap<String, ApplicationScope> validScopes) {
        if (requestedScopes == null || requestedScopes.length == 0) {
            return new TreeMap<String, ApplicationScope>();
        }
        if (validScopes == null) {
            throw new RFC6749.InvalidScopeException();
        }
        TreeMap<String, ApplicationScope> results = new TreeMap<String, ApplicationScope>();
        for (String scope : requestedScopes) {
            if (!validScopes.containsKey(scope)) continue;
            results.put(scope, (ApplicationScope)((Object)validScopes.get(scope)));
        }
        return results;
    }

    public static SortedMap<String, ApplicationScope> validateScope(String requestedScopes, SortedMap<String, ApplicationScope> validScopes) {
        if (StringUtils.isEmpty((CharSequence)requestedScopes)) {
            return new TreeMap<String, ApplicationScope>();
        }
        String decodedScopes = URLDecoder.decode(requestedScopes);
        return ValidationUtil.validateScope(decodedScopes.split(" "), validScopes);
    }

    public static SortedMap<String, ApplicationScope> validateScope(SortedMap<String, ApplicationScope> requestedScopes, Role role) {
        if (role == null) {
            throw new RFC6749.InvalidScopeException();
        }
        Collection<ApplicationScope> roleScope = role.getScopes().values();
        for (ApplicationScope s : requestedScopes.values()) {
            if (roleScope.contains((Object)s)) continue;
            throw new RFC6749.InvalidScopeException();
        }
        return requestedScopes;
    }

    public static SortedMap<String, ApplicationScope> validateScope(String requestedScopes, Role role) {
        if (role == null) {
            throw new RFC6749.InvalidScopeException();
        }
        return ValidationUtil.validateScope(requestedScopes, role.getScopes());
    }

    public static SortedMap<String, ApplicationScope> revalidateScope(String[] requestedScopes, SortedMap<String, ApplicationScope> originalScopes, SortedMap<String, ApplicationScope> validScopes) {
        if (validScopes == null || originalScopes == null) {
            throw new RFC6749.InvalidScopeException();
        }
        if (requestedScopes == null || requestedScopes.length == 0) {
            return new TreeMap<String, ApplicationScope>();
        }
        TreeMap<String, ApplicationScope> results = new TreeMap<String, ApplicationScope>();
        for (String scope : requestedScopes) {
            if (!originalScopes.containsKey(scope)) {
                throw new RFC6749.InvalidScopeException();
            }
            if (!validScopes.containsKey(scope)) continue;
            results.put(scope, (ApplicationScope)((Object)validScopes.get(scope)));
        }
        return results;
    }

    public static SortedMap<String, ApplicationScope> revalidateScope(String requestedScopes, SortedMap<String, ApplicationScope> originalScopes, SortedMap<String, ApplicationScope> validScopes) {
        if (StringUtils.isEmpty((CharSequence)requestedScopes)) {
            return new TreeMap<String, ApplicationScope>();
        }
        return ValidationUtil.revalidateScope(requestedScopes.split(" "), originalScopes, validScopes);
    }

    public static SortedMap<String, ApplicationScope> revalidateScope(String requestedScopes, SortedMap<String, ApplicationScope> originalScopes, Role role) {
        if (role == null) {
            throw new RFC6749.InvalidScopeException();
        }
        return ValidationUtil.revalidateScope(requestedScopes, originalScopes, role.getScopes());
    }

    public static Authenticator validateAuthenticator(AuthenticatorType type, List<Authenticator> authenticators) {
        if (authenticators.size() == 0) {
            throw new RFC6749.InvalidRequestException();
        }
        if (type == null) {
            if (authenticators.size() == 1) {
                return authenticators.get(0);
            }
            throw new RFC6749.InvalidRequestException();
        }
        for (Authenticator test : authenticators) {
            if (!test.getType().equals((Object)type)) continue;
            return test;
        }
        throw new RFC6749.InvalidRequestException();
    }
}

