/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.util;

import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;

public final class PasswordUtil {
    private static final DigestRandomGenerator GENERATOR = new DigestRandomGenerator((Digest)new SHA3Digest(512));

    private PasswordUtil() {
    }

    public static String createSalt() {
        byte[] salt = new byte[32];
        GENERATOR.nextBytes(salt);
        return Base64.encodeBase64String((byte[])salt);
    }

    public static String hash(String password, String salt) {
        Integer keyLength = 512;
        Integer iterations = 101501;
        byte[] saltBytes = Base64.decodeBase64((String)salt);
        byte[] passBytes = PBEParametersGenerator.PKCS5PasswordToBytes((char[])password.toCharArray());
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        generator.init(passBytes, saltBytes, iterations.intValue());
        KeyParameter keys = (KeyParameter)generator.generateDerivedParameters(keyLength.intValue());
        byte[] encodedPassword = keys.getKey();
        return Base64.encodeBase64String((byte[])encodedPassword);
    }

    public static Boolean isValid(String password, String salt, String hashed) {
        return PasswordUtil.hash(password, salt).equals(hashed);
    }
}

