/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.jackson.Views;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.EnumBridge;

@Entity
@Indexed(index="user_identities")
@Table(name="user_identities")
@Analyzer(definition="entity_analyzer")
public final class UserIdentity
extends AbstractAuthzEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user", nullable=false, updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=User.Deserializer.class)
    @ContainedIn
    @JsonView(value={Views.Public.class})
    @IndexedEmbedded(includePaths={"id", "application.owner.id"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private User user;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false, updatable=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO, bridge=@FieldBridge(impl=EnumBridge.class))
    @NotNull
    @JsonView(value={Views.Public.class})
    @ApiModelProperty(required=true)
    private AuthenticatorType type;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="identity", cascade={CascadeType.REMOVE, CascadeType.MERGE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ContainedIn
    private List<OAuthToken> tokens = new ArrayList<OAuthToken>();
    @Basic(optional=false)
    @Column(name="remoteId", nullable=false, updatable=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO)
    @JsonView(value={Views.Public.class})
    @ApiModelProperty(required=true)
    private String remoteId;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="user_identity_claims", joinColumns={@JoinColumn(name="user_identity")})
    @MapKeyColumn(name="claimKey")
    @Column(name="claimValue")
    @Field(name="claims", index=Index.YES, analyze=Analyze.YES, store=Store.NO)
    @IndexedEmbedded
    @JsonView(value={Views.Public.class})
    private Map<String, String> claims = new HashMap<String, String>();
    @Basic
    @Column(name="salt")
    @JsonView(value={Views.Secure.class})
    @ApiModelProperty
    private String salt;
    @Basic
    @Column(name="password")
    @JsonView(value={Views.Secure.class})
    private String password;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public Map<String, String> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, String> claims) {
        this.claims = new HashMap<String, String>(claims);
    }

    public AuthenticatorType getType() {
        return this.type;
    }

    public void setType(AuthenticatorType authType) {
        this.type = authType;
    }

    public List<OAuthToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<OAuthToken> tokens) {
        this.tokens = new ArrayList<OAuthToken>(tokens);
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.user != null) {
            return this.user.getOwner();
        }
        return null;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<UserIdentity> {
        public Deserializer() {
            super(UserIdentity.class);
        }
    }
}

