/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;

@Entity
@Table(name="users")
@Indexed(index="users")
@Analyzer(definition="entity_analyzer")
public final class User
extends AbstractAuthzEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application", nullable=false, updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Application.Deserializer.class)
    @IndexedEmbedded(includePaths={"id", "owner.id"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Application application;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="owner", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    private List<Application> applications = new ArrayList<Application>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="role", nullable=true, updatable=true)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Role.Deserializer.class)
    @IndexedEmbedded(includePaths={"id"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Role role;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    @IndexedEmbedded(includePaths={"claims", "remoteId"})
    private List<UserIdentity> identities = new ArrayList<UserIdentity>();

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public List<UserIdentity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<UserIdentity> identities) {
        this.identities = new ArrayList<UserIdentity>(identities);
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(List<Application> applications) {
        this.applications = new ArrayList<Application>(applications);
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.application != null) {
            return this.application.getOwner();
        }
        return null;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<User> {
        public Deserializer() {
            super(User.class);
        }
    }
}

