/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.annotations.SortNatural;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Entity
@Table(name="roles")
@Indexed(index="roles")
@Analyzer(definition="entity_analyzer")
public final class Role
extends AbstractAuthzEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application", nullable=false, updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Application.Deserializer.class)
    @IndexedEmbedded(includePaths={"id", "owner.id"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Application application;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="role")
    @JsonIgnore
    @ContainedIn
    private List<User> users = new ArrayList<User>();
    @Basic(optional=false)
    @Column(name="name", nullable=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO)
    @Size(min=3, max=255, message="Role name must be between 3 and 255 characters.")
    @NotNull(message="A Role name is required")
    @ApiModelProperty(required=true)
    private String name;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="role_scopes", joinColumns={@JoinColumn(name="role", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="scope", nullable=false, updatable=false)})
    @JsonIgnore
    @MapKey(name="name")
    @SortNatural
    private SortedMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = new ArrayList<User>(users);
    }

    public SortedMap<String, ApplicationScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(SortedMap<String, ApplicationScope> scopes) {
        this.scopes = new TreeMap<String, ApplicationScope>(scopes);
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.application != null) {
            return this.application.getOwner();
        }
        return null;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<Role> {
        public Deserializer() {
            super(Role.class);
        }
    }
}

