/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.security.Principal;
import java.util.Calendar;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.HttpSession;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.SortNatural;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.EnumBridge;

@Entity
@Table(name="oauth_tokens")
@Indexed(index="oauth_tokens")
@Analyzer(definition="entity_analyzer")
public final class OAuthToken
extends AbstractAuthzEntity
implements Principal {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="identity", updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=UserIdentity.Deserializer.class)
    @IndexedEmbedded(includePaths={"id", "user.id", "remoteId", "claims"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private UserIdentity identity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="client", nullable=false, updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Client.Deserializer.class)
    @IndexedEmbedded(includePaths={"id", "application.owner.id"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Client client;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE, CascadeType.MERGE})
    @JoinColumn(name="authToken", nullable=true, updatable=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Deserializer.class)
    @ApiModelProperty(dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private OAuthToken authToken;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="httpSession")
    @JsonIgnore
    private HttpSession httpSession;
    @Enumerated(value=EnumType.STRING)
    @Column(name="tokenType", nullable=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO, bridge=@FieldBridge(impl=EnumBridge.class))
    @ApiModelProperty(required=true)
    private OAuthTokenType tokenType;
    @Basic(optional=false)
    @Column(name="expiresIn", nullable=false)
    @ApiModelProperty(required=true)
    private Long expiresIn;
    @Basic
    @Column(name="redirect", nullable=true)
    @Type(type="net.krotscheck.kangaroo.common.hibernate.type.URIType")
    private URI redirect;
    @Basic
    @Column(name="issuer")
    private String issuer;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="oauth_token_scopes", joinColumns={@JoinColumn(name="token", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="scope", nullable=false, updatable=false)})
    @MapKey(name="name")
    @SortNatural
    private SortedMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public UserIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(UserIdentity identity) {
        this.identity = identity;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public OAuthToken getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(OAuthToken authToken) {
        this.authToken = authToken;
    }

    public OAuthTokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(OAuthTokenType tokenType) {
        this.tokenType = tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonSetter
    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setExpiresIn(Number expiresIn) {
        this.expiresIn = expiresIn == null ? null : Long.valueOf(expiresIn.longValue());
    }

    @JsonIgnore
    public SortedMap<String, ApplicationScope> getScopes() {
        return this.scopes;
    }

    @JsonIgnore
    public void setScopes(SortedMap<String, ApplicationScope> scopes) {
        this.scopes = new TreeMap<String, ApplicationScope>(scopes);
    }

    @Transient
    @JsonIgnore
    public boolean isExpired() {
        if (this.getCreatedDate() == null) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        Calendar expireDate = (Calendar)this.getCreatedDate().clone();
        expireDate.add(13, this.getExpiresIn().intValue());
        return now.after(expireDate);
    }

    public URI getRedirect() {
        return this.redirect;
    }

    public void setRedirect(URI redirect) {
        this.redirect = redirect;
    }

    @Override
    @Transient
    @JsonIgnore
    public String getName() {
        Client c = this.getClient();
        UserIdentity i = this.getIdentity();
        if (c != null && c.getType().equals((Object)ClientType.ClientCredentials)) {
            return c.getName();
        }
        if (i != null) {
            return i.getRemoteId();
        }
        return null;
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.client != null) {
            return this.client.getOwner();
        }
        return null;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<OAuthToken> {
        public Deserializer() {
            super(OAuthToken.class);
        }
    }
}

