/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Strings;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientConfig;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientReferrer;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Entity
@Table(name="clients")
@Indexed(index="clients")
@Analyzer(definition="entity_analyzer")
public final class Client
extends AbstractAuthzEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application", nullable=false, updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Application.Deserializer.class)
    @IndexedEmbedded(includePaths={"id", "owner.id"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Application application;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="client", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    private List<Authenticator> authenticators = new ArrayList<Authenticator>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="client", cascade={CascadeType.REMOVE, CascadeType.MERGE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ContainedIn
    private List<OAuthToken> tokens = new ArrayList<OAuthToken>();
    @Basic(optional=false)
    @Column(name="name", nullable=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO)
    @Size(min=3, max=255, message="Client name must be between 3 and 255 characters.")
    @ApiModelProperty(required=true)
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    @NotNull
    private ClientType type;
    @Basic
    @Column(name="clientSecret", updatable=true, nullable=true)
    private String clientSecret;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="client", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    @IndexedEmbedded(includePaths={"id", "uri"})
    private List<ClientReferrer> referrers = new ArrayList<ClientReferrer>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="client", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    @IndexedEmbedded(includePaths={"id", "uri"})
    private List<ClientRedirect> redirects = new ArrayList<ClientRedirect>();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_configs", joinColumns={@JoinColumn(name="client")})
    @MapKeyColumn(name="configKey")
    @Column(name="configValue")
    private Map<String, String> configuration = new TreeMap<String, String>();

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public List<ClientReferrer> getReferrers() {
        return this.referrers;
    }

    public void setReferrers(List<ClientReferrer> referrers) {
        this.referrers = new ArrayList<ClientReferrer>(referrers);
    }

    public List<ClientRedirect> getRedirects() {
        return this.redirects;
    }

    public void setRedirects(List<ClientRedirect> redirects) {
        this.redirects = new ArrayList<ClientRedirect>(redirects);
    }

    public List<Authenticator> getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(List<Authenticator> authenticators) {
        this.authenticators = new ArrayList<Authenticator>(authenticators);
    }

    public List<OAuthToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<OAuthToken> tokens) {
        this.tokens = new ArrayList<OAuthToken>(tokens);
    }

    public ClientType getType() {
        return this.type;
    }

    public void setType(ClientType type) {
        this.type = type;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = new HashMap<String, String>(configuration);
    }

    @JsonIgnore
    public Integer getAuthorizationCodeExpiresIn() {
        try {
            Map<String, String> config = this.getConfiguration();
            String value = config.get("authorization_code_expires_in");
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return ClientConfig.AUTHORIZATION_CODE_EXPIRES_DEFAULT;
        }
    }

    @JsonIgnore
    public Integer getAccessTokenExpireIn() {
        try {
            Map<String, String> config = this.getConfiguration();
            String value = config.get("access_token_expires_in");
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return ClientConfig.ACCESS_TOKEN_EXPIRES_DEFAULT;
        }
    }

    @JsonIgnore
    public Integer getRefreshTokenExpireIn() {
        try {
            Map<String, String> config = this.getConfiguration();
            String value = config.get("refresh_token_expires_in");
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return ClientConfig.REFRESH_TOKEN_EXPIRES_DEFAULT;
        }
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.application != null) {
            return this.application.getOwner();
        }
        return null;
    }

    @Transient
    @JsonIgnore
    public Boolean isPrivate() {
        return !Strings.isNullOrEmpty((String)this.clientSecret);
    }

    @Transient
    @JsonIgnore
    public Boolean isPublic() {
        return this.isPrivate() == false;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<Client> {
        public Deserializer() {
            super(Client.class);
        }
    }
}

