/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import org.hibernate.annotations.SortNatural;
import org.hibernate.annotations.Type;

@Entity
@Table(name="authenticator_states")
public final class AuthenticatorState
extends AbstractAuthzEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="authenticator", nullable=false, updatable=false)
    private Authenticator authenticator;
    @Basic
    @Column(name="clientState", unique=false)
    private String clientState;
    @Basic(optional=false)
    @Column(name="clientRedirect", unique=false)
    @Type(type="net.krotscheck.kangaroo.common.hibernate.type.URIType")
    private URI clientRedirect;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="authenticator_state_scopes", joinColumns={@JoinColumn(name="authenticator_state", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="scope", nullable=false, updatable=false)})
    @MapKey(name="name")
    @SortNatural
    private SortedMap<String, ApplicationScope> clientScopes = new TreeMap<String, ApplicationScope>();

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public URI getClientRedirect() {
        return this.clientRedirect;
    }

    public void setClientRedirect(URI clientRedirect) {
        this.clientRedirect = clientRedirect;
    }

    public SortedMap<String, ApplicationScope> getClientScopes() {
        return this.clientScopes;
    }

    public void setClientScopes(SortedMap<String, ApplicationScope> clientScopes) {
        this.clientScopes = new TreeMap<String, ApplicationScope>(clientScopes);
    }

    public String getClientState() {
        return this.clientState;
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.authenticator != null) {
            return this.authenticator.getOwner();
        }
        return null;
    }

    public void setClientState(String clientState) {
        this.clientState = clientState;
    }
}

