/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.AuthenticatorState;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.jackson.Views;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.EnumBridge;

@Entity
@Table(name="authenticators")
@Indexed(index="authenticators")
@Analyzer(definition="entity_analyzer")
public final class Authenticator
extends AbstractAuthzEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="client", nullable=false, updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Client.Deserializer.class)
    @IndexedEmbedded(includePaths={"id", "application.owner.id", "name"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Client client;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="authenticator", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    private List<AuthenticatorState> states = new ArrayList<AuthenticatorState>();
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false, updatable=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO, bridge=@FieldBridge(impl=EnumBridge.class))
    @NotNull
    @JsonView(value={Views.Public.class})
    private AuthenticatorType type;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="authenticator_params", joinColumns={@JoinColumn(name="authenticator")})
    @MapKeyColumn(name="name")
    @Column(name="value")
    private Map<String, String> configuration = new HashMap<String, String>();

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public AuthenticatorType getType() {
        return this.type;
    }

    public void setType(AuthenticatorType type) {
        this.type = type;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public List<AuthenticatorState> getStates() {
        return this.states;
    }

    public void setStates(List<AuthenticatorState> states) {
        this.states = new ArrayList<AuthenticatorState>(states);
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.client != null) {
            return this.client.getOwner();
        }
        return null;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<Authenticator> {
        public Deserializer() {
            super(Authenticator.class);
        }
    }
}

