/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Entity
@Table(name="application_scopes")
@Indexed(index="application_scopes")
@Analyzer(definition="entity_analyzer")
public final class ApplicationScope
extends AbstractAuthzEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="application", nullable=false, updatable=false)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Application.Deserializer.class)
    @IndexedEmbedded(includePaths={"id", "owner.id"})
    @ApiModelProperty(required=true, dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Application application;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="scopes")
    @JsonIgnore
    private List<Role> roles = new ArrayList<Role>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="scopes")
    @JsonIgnore
    private List<OAuthToken> tokens = new ArrayList<OAuthToken>();
    @Basic(optional=false)
    @Column(name="name", nullable=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO)
    @Size(min=3, max=255, message="Scope name must be between 3 and 255 characters.")
    @ApiModelProperty(required=true)
    private String name;

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = new ArrayList<Role>(roles);
    }

    public List<OAuthToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<OAuthToken> tokens) {
        this.tokens = new ArrayList<OAuthToken>(tokens);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Transient
    @JsonIgnore
    public User getOwner() {
        if (this.application != null) {
            return this.application.getOwner();
        }
        return null;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<ApplicationScope> {
        public Deserializer() {
            super(ApplicationScope.class);
        }
    }
}

