/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.database.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.common.hibernate.id.AbstractEntityReferenceDeserializer;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.SortNatural;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Entity
@Table(name="applications")
@Indexed(index="applications")
@Analyzer(definition="entity_analyzer")
public final class Application
extends AbstractAuthzEntity {
    @OneToMany(fetch=FetchType.LAZY, mappedBy="application", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ContainedIn
    private List<User> users = new ArrayList<User>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="application", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ContainedIn
    private List<Client> clients = new ArrayList<Client>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="application", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    @OnDelete(action=OnDeleteAction.CASCADE)
    private List<Role> roles = new ArrayList<Role>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="application", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JsonIgnore
    @MapKey(name="name")
    @SortNatural
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ContainedIn
    private SortedMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owner", nullable=true, updatable=true)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=User.Deserializer.class)
    @IndexedEmbedded(includePaths={"id"})
    @ApiModelProperty(dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private User owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="defaultRole", nullable=true, updatable=true)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonDeserialize(using=Role.Deserializer.class)
    @IndexedEmbedded(includePaths={"id"})
    @ApiModelProperty(dataType="string", example="3f631a2d6a04f5cc55f9e192f45649b7")
    private Role defaultRole;
    @Basic(optional=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO)
    @Column(name="name", nullable=false)
    @Size(min=3, max=255, message="Application name must be between 3 and 255 characters.")
    @ApiModelProperty(required=true)
    private String name;
    @Basic(optional=false)
    @Field(index=Index.YES, analyze=Analyze.YES, store=Store.NO)
    @Column(name="description", nullable=true)
    @Size(max=255, message="Application description cannot exceed 255 characters.")
    private String description;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public void setClients(List<Client> clients) {
        this.clients = new ArrayList<Client>(clients);
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = new ArrayList<User>(users);
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = new ArrayList<Role>(roles);
    }

    public SortedMap<String, ApplicationScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(SortedMap<String, ApplicationScope> scopes) {
        this.scopes = new TreeMap<String, ApplicationScope>(scopes);
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public Role getDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(Role defaultRole) {
        this.defaultRole = defaultRole;
    }

    public static final class Deserializer
    extends AbstractEntityReferenceDeserializer<Application> {
        public Deserializer() {
            super(Application.class);
        }
    }
}

