/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.cors;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.authz.common.cors.HibernateCORSCacheLoader;
import net.krotscheck.kangaroo.common.cors.ICORSValidator;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;

public final class HibernateCORSValidator
implements ICORSValidator {
    private final LoadingCache<URI, Boolean> validDomains;

    @Inject
    public HibernateCORSValidator(HibernateCORSCacheLoader cacheLoader) {
        this.validDomains = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)cacheLoader);
    }

    public boolean isValidCORSOrigin(URI origin) {
        try {
            return (Boolean)this.validDomains.get((Object)origin);
        }
        catch (ExecutionException ee) {
            return false;
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(HibernateCORSValidator.class).to(ICORSValidator.class)).in(Singleton.class);
        }
    }
}

