/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.test;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.MisconfiguredAuthenticatorException;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public final class TestAuthenticator
implements IAuthenticator {
    public static final String REMOTE_ID = "dev_user";
    private final Session session;

    @Inject
    public TestAuthenticator(Session session) {
        this.session = session;
    }

    @Override
    public Response delegate(Authenticator configuration, URI callback) {
        return Response.status((Response.Status)Response.Status.FOUND).location(callback).build();
    }

    @Override
    public UserIdentity authenticate(Authenticator authenticator, MultivaluedMap<String, String> parameters, URI callback) {
        Criteria searchCriteria = this.session.createCriteria(UserIdentity.class);
        searchCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)authenticator.getType())));
        searchCriteria.add((Criterion)Restrictions.eq((String)"remoteId", (Object)REMOTE_ID));
        searchCriteria.createAlias("user", "u");
        searchCriteria.add((Criterion)Restrictions.eq((String)"u.application", (Object)((Object)authenticator.getClient().getApplication())));
        searchCriteria.setFirstResult(0);
        searchCriteria.setMaxResults(1);
        UserIdentity identity = (UserIdentity)((Object)searchCriteria.uniqueResult());
        if (identity == null) {
            Role testRole = authenticator.getClient().getApplication().getDefaultRole();
            User devUser = new User();
            devUser.setApplication(authenticator.getClient().getApplication());
            devUser.setRole(testRole);
            identity = new UserIdentity();
            identity.setType(authenticator.getType());
            identity.setRemoteId(REMOTE_ID);
            identity.setUser(devUser);
            this.session.save((Object)devUser);
            this.session.save((Object)identity);
        }
        return identity;
    }

    @Override
    public void validate(Authenticator authenticator) throws KangarooException {
        if (authenticator.getConfiguration().containsKey("invalid")) {
            throw new MisconfiguredAuthenticatorException();
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(TestAuthenticator.class).to(IAuthenticator.class)).named(AuthenticatorType.Test.name())).in(RequestScoped.class);
        }
    }
}

