/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.password;

import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.util.PasswordUtil;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.util.ParamUtil;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public final class PasswordAuthenticator
implements IAuthenticator {
    private final Session session;

    @Inject
    public PasswordAuthenticator(Session session) {
        this.session = session;
    }

    @Override
    public Response delegate(Authenticator configuration, URI callback) {
        return null;
    }

    @Override
    public UserIdentity authenticate(Authenticator authenticator, MultivaluedMap<String, String> parameters, URI callback) {
        if (authenticator == null || parameters == null) {
            throw new RFC6749.InvalidRequestException();
        }
        String login = ParamUtil.getOne(parameters, (String)"username");
        String password = ParamUtil.getOne(parameters, (String)"password");
        Criteria c = this.session.createCriteria(UserIdentity.class);
        c.add((Criterion)Restrictions.eq((String)"remoteId", (Object)login));
        c.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)authenticator.getType())));
        c.createAlias("user", "u");
        c.add((Criterion)Restrictions.eq((String)"u.application", (Object)((Object)authenticator.getClient().getApplication())));
        c.setFirstResult(0);
        c.setMaxResults(1);
        List results = c.list();
        if (c.list().size() == 0) {
            return null;
        }
        UserIdentity identity = (UserIdentity)((Object)results.get(0));
        Boolean isValid = PasswordUtil.isValid(password, identity.getSalt(), identity.getPassword());
        if (!isValid.booleanValue()) {
            return null;
        }
        return identity;
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)((ClassBinding)this.bind(PasswordAuthenticator.class).to(PasswordAuthenticator.class)).to(IAuthenticator.class)).named(AuthenticatorType.Password.name())).in(RequestScoped.class);
        }
    }
}

