/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.oauth2;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.MisconfiguredAuthenticatorException;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.ThirdPartyErrorException;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2IdPToken;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2User;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractOAuth2Authenticator
implements IAuthenticator {
    public static final GenericType<HashMap<String, String>> MAP_TYPE = new GenericType<HashMap<String, String>>(){};
    public static final String CLIENT_ID_KEY = "client_id";
    public static final String CLIENT_SECRET_KEY = "client_secret";
    @Inject
    private Client client;
    @Inject
    private Session session;

    public final Client getClient() {
        return this.client;
    }

    public final void setClient(Client client) {
        this.client = client;
    }

    public final Session getSession() {
        return this.session;
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    protected abstract String getAuthEndpoint();

    protected abstract String getTokenEndpoint();

    protected abstract String getScopes();

    private URI buildRedirect(URI uri) {
        return UriBuilder.fromUri((URI)uri).fragment(null).replaceQuery(null).build(new Object[0]);
    }

    protected final String getClientSecret(Authenticator authenticator) {
        return authenticator.getConfiguration().get(CLIENT_SECRET_KEY);
    }

    protected final String getClientId(Authenticator authenticator) {
        return authenticator.getConfiguration().get(CLIENT_ID_KEY);
    }

    @Override
    public final Response delegate(Authenticator authenticator, URI callback) {
        this.validate(authenticator);
        if (callback == null) {
            throw new RFC6749.ServerErrorException();
        }
        String state = (String)HttpUtil.parseQueryParams((URI)callback).getFirst((Object)"state");
        if (Strings.isNullOrEmpty((String)state)) {
            throw new RFC6749.ServerErrorException();
        }
        URI redirect = this.buildRedirect(callback);
        String clientId = this.getClientId(authenticator);
        UriBuilder b = UriBuilder.fromUri((String)this.getAuthEndpoint()).queryParam(CLIENT_ID_KEY, new Object[]{clientId}).queryParam("redirect_uri", new Object[]{redirect}).queryParam("response_type", new Object[]{"code"}).queryParam("state", new Object[]{state}).queryParam("scope", new Object[]{this.getScopes()});
        return Response.status((Response.Status)Response.Status.FOUND).location(b.build(new Object[0])).build();
    }

    @Override
    public final void validate(Authenticator authenticator) throws KangarooException {
        if (authenticator == null || authenticator.getConfiguration() == null) {
            throw new MisconfiguredAuthenticatorException();
        }
        Map<String, String> config = authenticator.getConfiguration();
        String clientId = config.getOrDefault(CLIENT_ID_KEY, null);
        String clientSecret = config.getOrDefault(CLIENT_SECRET_KEY, null);
        if (Strings.isNullOrEmpty((String)clientSecret) || Strings.isNullOrEmpty((String)clientId)) {
            throw new MisconfiguredAuthenticatorException();
        }
    }

    @Override
    public final UserIdentity authenticate(Authenticator authenticator, MultivaluedMap<String, String> parameters, URI callback) {
        String clientSecret;
        URI redirect = this.buildRedirect(callback);
        if (parameters.containsKey((Object)"error")) {
            throw new ThirdPartyErrorException(parameters);
        }
        String code = (String)parameters.getFirst((Object)"code");
        if (Strings.isNullOrEmpty((String)code)) {
            throw new RFC6749.InvalidRequestException();
        }
        String clientId = this.getClientId(authenticator);
        OAuth2IdPToken token = this.resolveIdPToken(clientId, clientSecret = this.getClientSecret(authenticator), code, redirect);
        if (Strings.isNullOrEmpty((String)token.getAccessToken())) {
            throw new ThirdPartyErrorException();
        }
        OAuth2User oUser = this.loadUserIdentity(token);
        if (Strings.isNullOrEmpty((String)oUser.getId())) {
            throw new ThirdPartyErrorException();
        }
        Application application = authenticator.getClient().getApplication();
        Criteria criteria = this.session.createCriteria(UserIdentity.class).createAlias("user", "u").add((Criterion)Restrictions.eq((String)"type", (Object)((Object)authenticator.getType()))).add((Criterion)Restrictions.eq((String)"remoteId", (Object)oUser.getId())).add((Criterion)Restrictions.eq((String)"u.application", (Object)((Object)application))).setFirstResult(0).setMaxResults(1);
        UserIdentity identity = (UserIdentity)((Object)criteria.uniqueResult());
        if (identity == null) {
            User u = new User();
            u.setApplication(application);
            u.setRole(application.getDefaultRole());
            identity = new UserIdentity();
            identity.setUser(u);
            identity.setType(authenticator.getType());
            identity.setRemoteId(oUser.getId());
            identity.setClaims(oUser.getClaims());
            this.session.save((Object)u);
            this.session.save((Object)identity);
        } else {
            identity.getClaims().putAll(oUser.getClaims());
            this.session.save((Object)identity);
        }
        return identity;
    }

    protected abstract OAuth2User loadUserIdentity(OAuth2IdPToken var1);

    private OAuth2IdPToken resolveIdPToken(String clientId, String clientSecret, String authorizationCode, URI redirectUrl) {
        String authHeader = HttpUtil.authHeaderBasic((String)clientId, (String)clientSecret);
        Form f = new Form();
        f.param(CLIENT_ID_KEY, clientId);
        f.param("code", authorizationCode);
        f.param("grant_type", "authorization_code");
        f.param("redirect_uri", redirectUrl.toString());
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        try (Response r = this.client.target(this.getTokenEndpoint()).request().header("Authorization", (Object)authHeader).post(postEntity);){
            if (r.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                OAuth2IdPToken oAuth2IdPToken = (OAuth2IdPToken)r.readEntity(OAuth2IdPToken.class);
                return oAuth2IdPToken;
            }
            try {
                Map params = (Map)r.readEntity(MAP_TYPE);
                throw new ThirdPartyErrorException(params);
            }
            catch (ProcessingException e) {
                throw new ThirdPartyErrorException();
            }
        }
    }
}

