/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.google;

import com.google.common.base.Strings;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.ThirdPartyErrorException;
import net.krotscheck.kangaroo.authz.common.authenticator.google.GoogleUserEntity;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.AbstractOAuth2Authenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2IdPToken;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2User;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;

public final class GoogleAuthenticator
extends AbstractOAuth2Authenticator {
    @Override
    protected String getAuthEndpoint() {
        return "https://accounts.google.com/o/oauth2/v2/auth";
    }

    @Override
    protected String getTokenEndpoint() {
        return "https://www.googleapis.com/oauth2/v4/token";
    }

    @Override
    protected String getScopes() {
        return StringUtils.join((Object[])new String[]{"https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/userinfo.profile"}, (String)" ");
    }

    @Override
    protected OAuth2User loadUserIdentity(OAuth2IdPToken token) {
        try (Response r = this.getClient().target("https://www.googleapis.com/oauth2/v1/userinfo").request().header("Authorization", (Object)HttpUtil.authHeaderBearer((String)token.getAccessToken())).get();){
            if (r.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                GoogleUserEntity gUser = (GoogleUserEntity)r.readEntity(GoogleUserEntity.class);
                if (Strings.isNullOrEmpty((String)gUser.getId())) {
                    throw new ThirdPartyErrorException();
                }
                OAuth2User oAuth2User = gUser.asGenericUser();
                return oAuth2User;
            }
            try {
                Map params = (Map)r.readEntity(MAP_TYPE);
                throw new ThirdPartyErrorException(params);
            }
            catch (ProcessingException e) {
                throw new ThirdPartyErrorException();
            }
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(GoogleAuthenticator.class).to(IAuthenticator.class)).named(AuthenticatorType.Google.name())).in(RequestScoped.class);
        }
    }
}

