/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.common.authenticator.facebook;

import com.google.common.base.Strings;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.exception.ThirdPartyErrorException;
import net.krotscheck.kangaroo.authz.common.authenticator.facebook.FacebookUserEntity;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.AbstractOAuth2Authenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2IdPToken;
import net.krotscheck.kangaroo.authz.common.authenticator.oauth2.OAuth2User;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;

public final class FacebookAuthenticator
extends AbstractOAuth2Authenticator {
    private static final String USER_ENDPOINT = "https://graph.facebook.com/v2.10/me";

    @Override
    protected String getAuthEndpoint() {
        return "https://www.facebook.com/v2.10/dialog/oauth";
    }

    @Override
    protected String getTokenEndpoint() {
        return "https://graph.facebook.com/v2.10/oauth/access_token";
    }

    @Override
    protected String getScopes() {
        return "public_profile,email";
    }

    @Override
    protected OAuth2User loadUserIdentity(OAuth2IdPToken token) {
        try (Response r = this.getClient().target(USER_ENDPOINT).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((String)token.getAccessToken())).get();){
            if (r.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                FacebookUserEntity fbUser = (FacebookUserEntity)r.readEntity(FacebookUserEntity.class);
                if (Strings.isNullOrEmpty((String)fbUser.getId())) {
                    throw new ThirdPartyErrorException();
                }
                OAuth2User oAuth2User = fbUser.asGenericUser();
                return oAuth2User;
            }
            try {
                Map params = (Map)r.readEntity(MAP_TYPE);
                throw new ThirdPartyErrorException(params);
            }
            catch (ProcessingException e) {
                throw new ThirdPartyErrorException();
            }
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(FacebookAuthenticator.class).to(IAuthenticator.class)).named(AuthenticatorType.Facebook.name())).in(RequestScoped.class);
        }
    }
}

