/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.servlet;

import java.math.BigInteger;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.authz.admin.Scope;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.util.PasswordUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirstRunContainerLifecycleListener
implements ContainerLifecycleListener {
    private static Logger logger = LoggerFactory.getLogger(FirstRunContainerLifecycleListener.class);
    private final SessionFactory sessionFactory;
    private final Configuration servletConfig;
    private final DatabaseMigrationState migrationState;

    @Inject
    public FirstRunContainerLifecycleListener(SessionFactory sessionFactory, @Named(value="kangaroo-servlet-admin") Configuration servletConfig, DatabaseMigrationState migrationState) {
        this.sessionFactory = sessionFactory;
        this.servletConfig = servletConfig;
        this.migrationState = migrationState;
    }

    private Application bootstrapApplication() {
        logger.debug("Bootstrapping Application");
        Session s = this.sessionFactory.openSession();
        Application servletApp = new Application();
        servletApp.setName("Kangaroo");
        servletApp.setDescription("The kangaroo administration application.");
        Client servletClient = new Client();
        servletClient.setApplication(servletApp);
        servletClient.setName("Kangaroo Web UI");
        servletClient.setType(ClientType.OwnerCredentials);
        Authenticator passwordAuth = new Authenticator();
        passwordAuth.setType(AuthenticatorType.Password);
        passwordAuth.setClient(servletClient);
        TreeMap<String, ApplicationScope> userScopes = new TreeMap<String, ApplicationScope>();
        for (String string : Scope.userScopes()) {
            ApplicationScope newScope = new ApplicationScope();
            newScope.setApplication(servletApp);
            newScope.setName(string);
            userScopes.put(string, newScope);
        }
        TreeMap<String, ApplicationScope> adminScopes = new TreeMap<String, ApplicationScope>();
        for (String scopeName : Scope.adminScopes()) {
            ApplicationScope newScope = new ApplicationScope();
            newScope.setApplication(servletApp);
            newScope.setName(scopeName);
            adminScopes.put(scopeName, newScope);
        }
        Role role = new Role();
        role.setName("admin");
        role.setApplication(servletApp);
        role.setScopes(adminScopes);
        Role memberRole = new Role();
        memberRole.setName("member");
        memberRole.setApplication(servletApp);
        memberRole.setScopes(userScopes);
        servletApp.setDefaultRole(memberRole);
        User adminUser = new User();
        adminUser.setApplication(servletApp);
        adminUser.setRole(role);
        servletApp.setOwner(adminUser);
        UserIdentity adminIdentity = new UserIdentity();
        adminIdentity.setType(AuthenticatorType.Password);
        adminIdentity.setRemoteId("admin");
        adminIdentity.setUser(adminUser);
        adminIdentity.setSalt(PasswordUtil.createSalt());
        adminIdentity.setPassword(PasswordUtil.hash("admin", adminIdentity.getSalt()));
        s.getTransaction().begin();
        s.save((Object)servletApp);
        s.save((Object)servletClient);
        s.save((Object)passwordAuth);
        adminScopes.forEach((arg_0, arg_1) -> ((Session)s).save(arg_0, arg_1));
        userScopes.forEach((arg_0, arg_1) -> ((Session)s).save(arg_0, arg_1));
        s.save((Object)role);
        s.save((Object)memberRole);
        s.save((Object)adminUser);
        s.save((Object)adminIdentity);
        s.getTransaction().commit();
        logger.debug(String.format("Application ID: %s", IdUtil.toString((BigInteger)servletApp.getId())));
        logger.debug(String.format("Admin User ID: %s", IdUtil.toString((BigInteger)adminUser.getId())));
        logger.debug(String.format("WebUI Client ID: %s", IdUtil.toString((BigInteger)servletClient.getId())));
        logger.debug("Application created. Let's rock!");
        this.servletConfig.addProperty("application_id", (Object)IdUtil.toString((BigInteger)servletApp.getId()));
        this.servletConfig.addProperty("application_client_id", (Object)IdUtil.toString((BigInteger)servletClient.getId()));
        this.servletConfig.addProperty("application_admin_id", (Object)IdUtil.toString((BigInteger)adminUser.getId()));
        s.refresh((Object)servletApp);
        s.close();
        return servletApp;
    }

    public void onStartup(Container container) {
        Boolean firstRun = this.servletConfig.getBoolean("first_run", false);
        if (!firstRun.booleanValue()) {
            this.bootstrapApplication();
            this.servletConfig.addProperty("first_run", (Object)true);
        }
    }

    public void onReload(Container container) {
    }

    public void onShutdown(Container container) {
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(FirstRunContainerLifecycleListener.class).to(ContainerLifecycleListener.class)).in(Singleton.class);
        }
    }
}

