/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/user")
@ScopesAllowed(value={"kangaroo:user", "kangaroo:user_admin"})
@Transactional
@Api(tags={"User"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:user", description="Modify users in one application."), @AuthorizationScope(scope="kangaroo:user_admin", description="Modify users in all applications.")})})
public final class UserService
extends AbstractService {
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search users")
    public Response searchUsers(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="10") @QueryParam(value="limit") Integer limit, @DefaultValue(value="") @QueryParam(value="q") String queryString, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="application") BigInteger applicationId, @ApiParam(type="string") @Optional @QueryParam(value="role") BigInteger roleId) {
        Role filterByRole;
        Application filterByApp;
        QueryBuilder builder = this.getSearchFactory().buildQueryBuilder().forEntity(User.class).get();
        BooleanJunction junction = builder.bool();
        Query fuzzy = builder.keyword().fuzzy().onFields(new String[]{"identities.claims", "identities.remoteId"}).matching((Object)queryString).createQuery();
        junction = junction.must(fuzzy);
        User owner = this.resolveOwnershipFilter(ownerId);
        if (owner != null) {
            Query ownerQuery = builder.keyword().onField("application.owner.id").matching((Object)owner.getId()).createQuery();
            junction.must(ownerQuery);
        }
        if ((filterByApp = this.resolveFilterEntity(Application.class, applicationId)) != null) {
            Query userQuery = builder.keyword().onField("application.id").matching((Object)filterByApp.getId()).createQuery();
            junction.must(userQuery);
        }
        if ((filterByRole = this.resolveFilterEntity(Role.class, roleId)) != null) {
            Query userQuery = builder.keyword().onField("role.id").matching((Object)filterByRole.getId()).createQuery();
            junction.must(userQuery);
        }
        FullTextQuery query = this.getFullTextSession().createFullTextQuery(junction.createQuery(), new Class[]{User.class});
        return this.executeQuery(User.class, query, offset, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse users")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="application") BigInteger applicationId, @ApiParam(type="string") @Optional @QueryParam(value="role") BigInteger roleId) {
        User filterByOwner = this.resolveOwnershipFilter(ownerId);
        Application filterByApp = this.resolveFilterEntity(Application.class, applicationId);
        Role filterByRole = this.resolveFilterEntity(Role.class, roleId);
        Criteria countCriteria = this.getSession().createCriteria(User.class).createAlias("application", "a").setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(User.class).createAlias("application", "a").setFirstResult(offset).setMaxResults(limit).addOrder(SortUtil.order(order, sort));
        if (filterByApp != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"a.id", (Object)filterByApp.getId()));
            countCriteria.add((Criterion)Restrictions.eq((String)"a.id", (Object)filterByApp.getId()));
        }
        if (filterByOwner != null) {
            browseCriteria.createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
            countCriteria.createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
        }
        if (filterByRole != null) {
            browseCriteria.createAlias("role", "r").add((Criterion)Restrictions.eq((String)"r.id", (Object)filterByRole.getId()));
            countCriteria.createAlias("role", "r").add((Criterion)Restrictions.eq((String)"r.id", (Object)filterByRole.getId()));
        }
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read user")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        User scope = (User)((Object)this.getSession().get(User.class, (Serializable)id));
        this.assertCanAccess(scope, this.getAdminScope());
        return Response.ok((Object)((Object)scope)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create user")
    public Response createResource(User user) {
        if (user == null) {
            throw new BadRequestException();
        }
        if (user.getId() != null) {
            throw new BadRequestException();
        }
        if (user.getApplication() == null) {
            throw new BadRequestException();
        }
        if (!this.getSecurityContext().isUserInRole(this.getAdminScope())) {
            Application scopeApp = (Application)((Object)this.getSession().get(Application.class, (Serializable)user.getApplication().getId()));
            if (this.getCurrentUser() == null || !this.getCurrentUser().equals((Object)scopeApp.getOwner())) {
                throw new BadRequestException();
            }
        }
        Session s = this.getSession();
        s.save((Object)user);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(UserService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)user.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update user")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, User user) {
        Session s = this.getSession();
        User currentUser = (User)((Object)s.get(User.class, (Serializable)id));
        this.assertCanAccess(currentUser, this.getAdminScope());
        if (!currentUser.equals((Object)user)) {
            throw new BadRequestException();
        }
        if (!currentUser.getApplication().equals((Object)user.getApplication())) {
            throw new BadRequestException();
        }
        currentUser.setRole(user.getRole());
        s.update((Object)currentUser);
        return Response.ok((Object)((Object)user)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete user")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        User user = (User)((Object)s.get(User.class, (Serializable)id));
        this.assertCanAccess(user, this.getAdminScope());
        s.delete((Object)user);
        return Response.noContent().build();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:user_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:user";
    }
}

