/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.database.jackson.Views;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.authz.common.util.PasswordUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/identity")
@ScopesAllowed(value={"kangaroo:identity", "kangaroo:identity_admin"})
@Transactional
@Api(tags={"User Identity"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:identity", description="Modify identities in one application."), @AuthorizationScope(scope="kangaroo:identity_admin", description="Modify identities in all applications.")})})
public final class UserIdentityService
extends AbstractService {
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @JsonView(value={Views.Public.class})
    @ApiOperation(value="Search user identities")
    public Response search(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="10") @QueryParam(value="limit") Integer limit, @DefaultValue(value="") @QueryParam(value="q") String queryString, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="user") BigInteger userId, @Optional @QueryParam(value="type") AuthenticatorType type) {
        User filterByUser;
        QueryBuilder builder = this.getSearchFactory().buildQueryBuilder().forEntity(UserIdentity.class).get();
        BooleanJunction junction = builder.bool();
        Query fuzzy = builder.keyword().fuzzy().onFields(new String[]{"claims", "remoteId"}).matching((Object)queryString).createQuery();
        junction = junction.must(fuzzy);
        User owner = this.resolveOwnershipFilter(ownerId);
        if (owner != null) {
            Query ownerQuery = builder.keyword().onField("user.application.owner.id").matching((Object)owner.getId()).createQuery();
            junction.must(ownerQuery);
        }
        if ((filterByUser = this.resolveFilterEntity(User.class, userId)) != null) {
            Query userQuery = builder.keyword().onField("user.id").matching((Object)filterByUser.getId()).createQuery();
            junction.must(userQuery);
        }
        if (type != null) {
            Query typeQuery = builder.keyword().onField("type").matching((Object)type).createQuery();
            junction.must(typeQuery);
        }
        FullTextQuery query = this.getFullTextSession().createFullTextQuery(junction.createQuery(), new Class[]{UserIdentity.class});
        return this.executeQuery(UserIdentity.class, query, offset, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @JsonView(value={Views.Public.class})
    @ApiOperation(value="Browse user identities")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="user") BigInteger userId, @Optional @QueryParam(value="type") AuthenticatorType type) {
        User filterByOwner = this.resolveOwnershipFilter(ownerId);
        User filterByUser = this.resolveFilterEntity(User.class, userId);
        Criteria countCriteria = this.getSession().createCriteria(UserIdentity.class).createAlias("user", "u").setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(UserIdentity.class).setFirstResult(offset).setMaxResults(limit).createAlias("user", "u").addOrder(SortUtil.order(order, sort));
        if (filterByUser != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"u.id", (Object)filterByUser.getId()));
            countCriteria.add((Criterion)Restrictions.eq((String)"u.id", (Object)filterByUser.getId()));
        }
        if (type != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)type)));
            countCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)type)));
        }
        if (filterByOwner != null) {
            browseCriteria.createAlias("u.application", "a").createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
            countCriteria.createAlias("u.application", "a").createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
        }
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @JsonView(value={Views.Public.class})
    @ApiOperation(value="Read user identity")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        UserIdentity identity = (UserIdentity)((Object)this.getSession().get(UserIdentity.class, (Serializable)id));
        this.assertCanAccess(identity, this.getAdminScope());
        return Response.ok((Object)((Object)identity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @JsonView(value={Views.Public.class})
    @ApiOperation(value="Create user identity")
    public Response createResource(UserIdentity identity) {
        if (identity == null) {
            throw new BadRequestException();
        }
        if (identity.getId() != null) {
            throw new BadRequestException();
        }
        if (identity.getType() == null) {
            throw new BadRequestException();
        }
        if (identity.getUser() == null) {
            throw new BadRequestException();
        }
        if (identity.getRemoteId() == null) {
            throw new BadRequestException();
        }
        if (identity.getPassword() == null) {
            throw new BadRequestException();
        }
        User parent = (User)((Object)this.getSession().get(User.class, (Serializable)identity.getUser().getId()));
        if (parent == null) {
            throw new BadRequestException();
        }
        if (!this.getSecurityContext().isUserInRole(this.getAdminScope())) {
            Application scopeApp = parent.getApplication();
            if (this.getCurrentUser() == null || !this.getCurrentUser().equals((Object)scopeApp.getOwner())) {
                throw new BadRequestException();
            }
        }
        if (!identity.getType().equals((Object)AuthenticatorType.Password)) {
            throw new BadRequestException();
        }
        String salt = PasswordUtil.createSalt();
        String passwordHash = PasswordUtil.hash(identity.getPassword(), salt);
        identity.setSalt(salt);
        identity.setPassword(passwordHash);
        Session s = this.getSession();
        s.save((Object)identity);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(UserIdentityService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)identity.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JsonView(value={Views.Public.class})
    @ApiOperation(value="Update user identity")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, UserIdentity identity) {
        Session s = this.getSession();
        UserIdentity current = (UserIdentity)((Object)s.get(UserIdentity.class, (Serializable)id));
        this.assertCanAccess(current, this.getAdminScope());
        if (!current.equals((Object)identity)) {
            throw new BadRequestException();
        }
        if (!current.getUser().equals((Object)identity.getUser())) {
            throw new BadRequestException();
        }
        if (!current.getType().equals((Object)identity.getType())) {
            throw new BadRequestException();
        }
        current.setClaims(identity.getClaims());
        current.setPassword(identity.getPassword());
        s.update((Object)current);
        return Response.ok((Object)((Object)current)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @JsonView(value={Views.Public.class})
    @ApiOperation(value="Delete user identity")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        UserIdentity identity = (UserIdentity)((Object)s.get(UserIdentity.class, (Serializable)id));
        this.assertCanAccess(identity, this.getAdminScope());
        s.delete((Object)identity);
        return Response.noContent().build();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:identity_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:identity";
    }
}

