/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.admin.v1.resource.RoleScopeService;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/role")
@ScopesAllowed(value={"kangaroo:role", "kangaroo:role_admin"})
@Transactional
@Api(tags={"Role"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:token", description="Modify roles in one application."), @AuthorizationScope(scope="kangaroo:token_admin", description="Modify roles in all applications.")})})
public final class RoleService
extends AbstractService {
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search roles")
    public Response search(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="10") @QueryParam(value="limit") Integer limit, @DefaultValue(value="") @QueryParam(value="q") String queryString, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="application") BigInteger applicationId) {
        Application filterByApp;
        QueryBuilder builder = this.getSearchFactory().buildQueryBuilder().forEntity(Role.class).get();
        BooleanJunction junction = builder.bool();
        Query fuzzy = builder.keyword().fuzzy().onFields(new String[]{"name"}).matching((Object)queryString).createQuery();
        junction = junction.must(fuzzy);
        User owner = this.resolveOwnershipFilter(ownerId);
        if (owner != null) {
            Query ownerQuery = builder.keyword().onField("application.owner.id").matching((Object)owner.getId()).createQuery();
            junction.must(ownerQuery);
        }
        if ((filterByApp = this.resolveFilterEntity(Application.class, applicationId)) != null) {
            Query appQuery = builder.keyword().onField("application.id").matching((Object)filterByApp.getId()).createQuery();
            junction.must(appQuery);
        }
        FullTextQuery query = this.getFullTextSession().createFullTextQuery(junction.createQuery(), new Class[]{Role.class});
        return this.executeQuery(Role.class, query, offset, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse roles")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="application") BigInteger applicationId) {
        User filterByOwner = this.resolveOwnershipFilter(ownerId);
        Application filterByApp = this.resolveFilterEntity(Application.class, applicationId);
        Criteria countCriteria = this.getSession().createCriteria(Role.class).createAlias("application", "a").setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(Role.class).createAlias("application", "a").setFirstResult(offset).setMaxResults(limit).addOrder(SortUtil.order(order, sort));
        if (filterByApp != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"a.id", (Object)filterByApp.getId()));
            countCriteria.add((Criterion)Restrictions.eq((String)"a.id", (Object)filterByApp.getId()));
        }
        if (filterByOwner != null) {
            browseCriteria.createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
            countCriteria.createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
        }
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read role")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Role role = (Role)((Object)this.getSession().get(Role.class, (Serializable)id));
        this.assertCanAccess(role, this.getAdminScope());
        return Response.ok((Object)((Object)role)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create role")
    public Response createResource(Role role) {
        if (role == null) {
            throw new BadRequestException();
        }
        if (role.getId() != null) {
            throw new BadRequestException();
        }
        if (role.getApplication() == null) {
            throw new BadRequestException();
        }
        if (!this.getSecurityContext().isUserInRole(this.getAdminScope())) {
            Application scopeApp = (Application)((Object)this.getSession().get(Application.class, (Serializable)role.getApplication().getId()));
            if (this.getCurrentUser() == null || !this.getCurrentUser().equals((Object)scopeApp.getOwner())) {
                throw new BadRequestException();
            }
        }
        Session s = this.getSession();
        s.save((Object)role);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(RoleService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)role.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update role")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, Role role) {
        Session s = this.getSession();
        Role current = (Role)((Object)s.get(Role.class, (Serializable)id));
        this.assertCanAccess(current, this.getAdminScope());
        if (!current.equals((Object)role)) {
            throw new BadRequestException();
        }
        if (current.getApplication().equals((Object)this.getAdminApplication())) {
            throw new ForbiddenException();
        }
        if (!current.getApplication().equals((Object)role.getApplication())) {
            throw new BadRequestException();
        }
        current.setName(role.getName());
        s.update((Object)current);
        return Response.ok((Object)((Object)role)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete role")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        Role role = (Role)((Object)s.get(Role.class, (Serializable)id));
        this.assertCanAccess(role, this.getAdminScope());
        if (role.getApplication().equals((Object)this.getAdminApplication())) {
            throw new ForbiddenException();
        }
        if (role.equals((Object)role.getApplication().getDefaultRole())) {
            throw new BadRequestException();
        }
        s.delete((Object)role);
        return Response.noContent().build();
    }

    @Path(value="/{id: [a-f0-9]{32}}/scope/")
    public RoleScopeService getScopeService(@ApiParam(type="string") @PathParam(value="id") BigInteger roleId) {
        RoleScopeService scopeService = (RoleScopeService)this.getInjector().getInstance(RoleScopeService.class);
        scopeService.setRoleId(roleId);
        return scopeService;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:role_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:role";
    }
}

