/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScope;
import org.hibernate.Session;

@ScopesAllowed(value={"kangaroo:role", "kangaroo:role_admin"})
@Transactional
@Api(tags={"Role"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:role", description="Modify scopes in one application."), @AuthorizationScope(scope="kangaroo:role_admin", description="Modify scopes in all applications.")})})
public final class RoleScopeService
extends AbstractService {
    private BigInteger roleId;

    public void setRoleId(BigInteger roleId) {
        this.roleId = roleId;
    }

    @POST
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Link a scope to a role")
    public Response createResource(@ApiParam(type="string") @PathParam(value="id") BigInteger scopeId) {
        Session s = this.getSession();
        SecurityContext security = this.getSecurityContext();
        Role role = (Role)((Object)s.get(Role.class, (Serializable)this.roleId));
        this.assertCanAccess(role, this.getAdminScope());
        ApplicationScope scope = (ApplicationScope)((Object)s.get(ApplicationScope.class, (Serializable)scopeId));
        if (!security.isUserInRole("kangaroo:scope") && !security.isUserInRole("kangaroo:scope_admin")) {
            throw new RFC6749.InvalidScopeException();
        }
        this.assertCanAccess(scope, "kangaroo:scope_admin");
        if (!role.getApplication().equals((Object)scope.getApplication())) {
            throw new BadRequestException();
        }
        if (role.getScopes().values().contains((Object)scope)) {
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        if (role.getApplication().equals((Object)this.getAdminApplication())) {
            throw new ForbiddenException();
        }
        role.getScopes().put(scope.getName(), scope);
        s.update((Object)role);
        return Response.created((URI)this.getUriInfo().getAbsolutePath()).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Unlink a scope from a role")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger scopeId) {
        Session s = this.getSession();
        SecurityContext security = this.getSecurityContext();
        Role role = (Role)((Object)s.get(Role.class, (Serializable)this.roleId));
        this.assertCanAccess(role, this.getAdminScope());
        ApplicationScope scope = (ApplicationScope)((Object)s.get(ApplicationScope.class, (Serializable)scopeId));
        if (!security.isUserInRole("kangaroo:scope") && !security.isUserInRole("kangaroo:scope_admin")) {
            throw new RFC6749.InvalidScopeException();
        }
        this.assertCanAccess(scope, "kangaroo:scope_admin");
        if (!role.getScopes().values().contains((Object)scope)) {
            throw new NotFoundException();
        }
        if (this.getAdminApplication().equals((Object)role.getApplication())) {
            throw new ForbiddenException();
        }
        role.getScopes().remove(scope.getName());
        s.update((Object)role);
        return Response.noContent().build();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:role_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:role";
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(RoleScopeService.class).to(RoleScopeService.class)).to(RequestScope.class);
        }
    }
}

