/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.apache.commons.lang.ObjectUtils;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/token")
@ScopesAllowed(value={"kangaroo:token_admin", "kangaroo:token"})
@Transactional
@Api(tags={"Token"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:token", description="Modify tokens in one application."), @AuthorizationScope(scope="kangaroo:token_admin", description="Modify tokens in all applications.")})})
public final class OAuthTokenService
extends AbstractService {
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search tokens")
    public Response search(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="10") @QueryParam(value="limit") Integer limit, @DefaultValue(value="") @QueryParam(value="q") String queryString, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="user") BigInteger userId, @ApiParam(type="string") @Optional @QueryParam(value="identity") BigInteger userIdentityId, @ApiParam(type="string") @Optional @QueryParam(value="client") BigInteger clientId, @Optional @QueryParam(value="type") OAuthTokenType type) {
        Client filterByClient;
        UserIdentity filterByIdentity;
        User filterByUser;
        QueryBuilder builder = this.getSearchFactory().buildQueryBuilder().forEntity(OAuthToken.class).get();
        BooleanJunction junction = builder.bool();
        Query fuzzy = builder.keyword().fuzzy().onFields(new String[]{"identity.remoteId", "identity.claims"}).matching((Object)queryString).createQuery();
        junction = junction.must(fuzzy);
        User owner = this.resolveOwnershipFilter(ownerId);
        if (owner != null) {
            Query ownerQuery = builder.keyword().onField("client.application.owner.id").matching((Object)owner.getId()).createQuery();
            junction.must(ownerQuery);
        }
        if ((filterByUser = this.resolveFilterEntity(User.class, userId)) != null) {
            Query userQuery = builder.keyword().onField("identity.user.id").matching((Object)filterByUser.getId()).createQuery();
            junction.must(userQuery);
        }
        if ((filterByIdentity = this.resolveFilterEntity(UserIdentity.class, userIdentityId)) != null) {
            Query identityQuery = builder.keyword().onField("identity.id").matching((Object)filterByIdentity.getId()).createQuery();
            junction.must(identityQuery);
        }
        if ((filterByClient = this.resolveFilterEntity(Client.class, clientId)) != null) {
            Query clientQuery = builder.keyword().onField("client.id").matching((Object)filterByClient.getId()).createQuery();
            junction.must(clientQuery);
        }
        if (type != null) {
            Query typeQuery = builder.keyword().onField("tokenType").matching((Object)type).createQuery();
            junction.must(typeQuery);
        }
        FullTextQuery query = this.getFullTextSession().createFullTextQuery(junction.createQuery(), new Class[]{OAuthToken.class});
        return this.executeQuery(OAuthToken.class, query, offset, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse tokens")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="identity") BigInteger userIdentityId, @ApiParam(type="string") @Optional @QueryParam(value="client") BigInteger clientId) {
        User filterByOwner = this.resolveOwnershipFilter(ownerId);
        UserIdentity filterByIdentity = this.resolveFilterEntity(UserIdentity.class, userIdentityId);
        Client filterByClient = this.resolveFilterEntity(Client.class, clientId);
        Criteria countCriteria = this.getSession().createCriteria(OAuthToken.class).createAlias("client", "c").setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(OAuthToken.class).setFirstResult(offset).setMaxResults(limit).createAlias("client", "c").addOrder(SortUtil.order(order, sort));
        if (filterByClient != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)filterByClient.getId()));
            countCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)filterByClient.getId()));
        }
        if (filterByIdentity != null) {
            browseCriteria.createAlias("identity", "i").add((Criterion)Restrictions.eq((String)"i.id", (Object)filterByIdentity.getId()));
            countCriteria.createAlias("identity", "i").add((Criterion)Restrictions.eq((String)"i.id", (Object)filterByIdentity.getId()));
        }
        if (filterByOwner != null) {
            browseCriteria.createAlias("c.application", "a").createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
            countCriteria.createAlias("c.application", "a").createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
        }
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read token")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        OAuthToken token = (OAuthToken)this.getSession().get(OAuthToken.class, (Serializable)id);
        this.assertCanAccess(token, this.getAdminScope());
        return Response.ok((Object)token).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create token")
    public Response createResource(OAuthToken token) {
        OAuthToken validToken = this.validateInputData(token);
        if (validToken.getId() != null) {
            throw new BadRequestException();
        }
        Client parent = validToken.getClient();
        if (!this.getSecurityContext().isUserInRole(this.getAdminScope())) {
            Application scopeApp = parent.getApplication();
            if (this.getCurrentUser() == null || !this.getCurrentUser().equals((Object)scopeApp.getOwner())) {
                throw new BadRequestException();
            }
        }
        Session s = this.getSession();
        s.save((Object)validToken);
        s.getTransaction().commit();
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(OAuthTokenService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)validToken.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update token")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, OAuthToken token) {
        Session s = this.getSession();
        OAuthToken current = (OAuthToken)s.get(OAuthToken.class, (Serializable)id);
        this.assertCanAccess(current, this.getAdminScope());
        if (!current.equals(token)) {
            throw new BadRequestException();
        }
        if (!ObjectUtils.equals((Object)((Object)current.getIdentity()), (Object)((Object)token.getIdentity()))) {
            throw new BadRequestException();
        }
        if (!ObjectUtils.equals((Object)((Object)current.getClient()), (Object)((Object)token.getClient()))) {
            throw new BadRequestException();
        }
        if (!current.getTokenType().equals((Object)token.getTokenType())) {
            throw new BadRequestException();
        }
        if (!ObjectUtils.equals((Object)current.getAuthToken(), (Object)token.getAuthToken())) {
            throw new BadRequestException();
        }
        OAuthToken validToken = this.validateInputData(token);
        current.setExpiresIn(validToken.getExpiresIn());
        current.setRedirect(validToken.getRedirect());
        s.update((Object)current);
        return Response.ok((Object)current).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete token")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        OAuthToken token = (OAuthToken)s.get(OAuthToken.class, (Serializable)id);
        this.assertCanAccess(token, this.getAdminScope());
        s.delete((Object)token);
        return Response.noContent().build();
    }

    private OAuthToken validateInputData(OAuthToken input) {
        URI redirect;
        if (input == null) {
            throw new BadRequestException();
        }
        if (input.getTokenType() == null) {
            throw new BadRequestException();
        }
        if (input.getExpiresIn() == null || input.getExpiresIn() < 1L) {
            throw new BadRequestException();
        }
        Client client = this.requireEntityInput(Client.class, input.getClient());
        ClientType clientType = client.getType();
        input.setClient(client);
        if (clientType.equals((Object)ClientType.OwnerCredentials) ? input.getTokenType().equals((Object)OAuthTokenType.Authorization) : clientType.in(ClientType.ClientCredentials, ClientType.Implicit) != false && !input.getTokenType().equals((Object)OAuthTokenType.Bearer)) {
            throw new BadRequestException();
        }
        if (clientType.equals((Object)ClientType.ClientCredentials)) {
            if (input.getIdentity() != null) {
                throw new BadRequestException();
            }
        } else {
            UserIdentity identity = this.requireEntityInput(UserIdentity.class, input.getIdentity());
            if (!identity.getUser().getApplication().equals((Object)client.getApplication())) {
                throw new BadRequestException();
            }
            input.setIdentity(identity);
        }
        if (!input.getTokenType().equals((Object)OAuthTokenType.Refresh)) {
            if (input.getAuthToken() != null) {
                throw new BadRequestException();
            }
        } else {
            OAuthToken authToken = this.requireEntityInput(OAuthToken.class, input.getAuthToken());
            if (!authToken.getTokenType().equals((Object)OAuthTokenType.Bearer)) {
                throw new BadRequestException();
            }
            if (!authToken.getIdentity().equals((Object)input.getIdentity())) {
                throw new BadRequestException();
            }
            input.setAuthToken(authToken);
        }
        if (!input.getTokenType().equals((Object)OAuthTokenType.Authorization) ? input.getRedirect() != null : (redirect = ValidationUtil.validateRedirect(input.getRedirect(), client.getRedirects())) == null) {
            throw new BadRequestException();
        }
        return input;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:token_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:token";
    }
}

