/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.apache.commons.configuration.Configuration;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Path(value="/config")
public final class ConfigService {
    private final Configuration config;
    private final Session session;

    @Inject
    public ConfigService(@Named(value="kangaroo-servlet-admin") Configuration config, Session session) {
        this.session = session;
        this.config = config;
    }

    @GET
    @Produces(value={"application/json"})
    public Response readConfiguration() {
        BigInteger applicationId = IdUtil.fromString((String)this.config.getString("application_id"));
        BigInteger clientId = IdUtil.fromString((String)this.config.getString("application_client_id"));
        this.session.beginTransaction();
        Application app = (Application)((Object)this.session.get(Application.class, (Serializable)applicationId));
        Criteria criteria = this.session.createCriteria(ApplicationScope.class);
        criteria.add((Criterion)Restrictions.eq((String)"application", (Object)((Object)app)));
        List<String> scopes = criteria.list().stream().map(ApplicationScope::getName).collect(Collectors.toList());
        this.session.getTransaction().commit();
        ConfigurationEntity e = new ConfigurationEntity();
        e.setClient(clientId);
        e.setScopes(scopes);
        return Response.ok((Object)e).build();
    }

    public static final class ConfigurationEntity {
        private BigInteger client;
        private List<String> scopes;

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public BigInteger getClient() {
            return this.client;
        }

        public void setClient(BigInteger client) {
            this.client = client;
        }
    }
}

