/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.admin.v1.resource.ClientRedirectService;
import net.krotscheck.kangaroo.authz.admin.v1.resource.ClientReferrerService;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/client")
@ScopesAllowed(value={"kangaroo:client", "kangaroo:client_admin"})
@Transactional
@Api(tags={"Client"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:client", description="Modify clients in one application."), @AuthorizationScope(scope="kangaroo:client_admin", description="Modify clients in all applications.")})})
public final class ClientService
extends AbstractService {
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search clients")
    public Response search(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="10") @QueryParam(value="limit") Integer limit, @DefaultValue(value="") @QueryParam(value="q") String queryString, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="application") BigInteger applicationId) {
        Application filterByApp;
        QueryBuilder builder = this.getSearchFactory().buildQueryBuilder().forEntity(Client.class).get();
        BooleanJunction junction = builder.bool();
        Query fuzzy = builder.keyword().fuzzy().onFields(new String[]{"name"}).matching((Object)queryString).createQuery();
        junction = junction.must(fuzzy);
        User owner = this.resolveOwnershipFilter(ownerId);
        if (owner != null) {
            Query ownerQuery = builder.keyword().onField("application.owner.id").matching((Object)owner.getId()).createQuery();
            junction.must(ownerQuery);
        }
        if ((filterByApp = this.resolveFilterEntity(Application.class, applicationId)) != null) {
            Query appQuery = builder.keyword().onField("application.id").matching((Object)filterByApp.getId()).createQuery();
            junction.must(appQuery);
        }
        FullTextQuery query = this.getFullTextSession().createFullTextQuery(junction.createQuery(), new Class[]{Client.class});
        return this.executeQuery(Client.class, query, offset, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse clients")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="application") BigInteger applicationId, @Optional @QueryParam(value="type") ClientType clientType) {
        User filterByOwner = this.resolveOwnershipFilter(ownerId);
        Application filterByApp = this.resolveFilterEntity(Application.class, applicationId);
        Criteria countCriteria = this.getSession().createCriteria(Client.class).createAlias("application", "a").setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(Client.class).createAlias("application", "a").setFirstResult(offset).setMaxResults(limit).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).addOrder(SortUtil.order(order, sort));
        if (filterByApp != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"a.id", (Object)filterByApp.getId()));
            countCriteria.add((Criterion)Restrictions.eq((String)"a.id", (Object)filterByApp.getId()));
        }
        if (filterByOwner != null) {
            browseCriteria.createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
            countCriteria.createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
        }
        if (clientType != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)clientType)));
            countCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)clientType)));
        }
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read client")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Client client = (Client)((Object)this.getSession().get(Client.class, (Serializable)id));
        this.assertCanAccess(client, this.getAdminScope());
        return Response.ok((Object)((Object)client)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create client")
    public Response createResource(Client client) {
        if (client == null) {
            throw new BadRequestException();
        }
        if (client.getId() != null) {
            throw new BadRequestException();
        }
        if (client.getApplication() == null) {
            throw new BadRequestException();
        }
        if (!this.getSecurityContext().isUserInRole(this.getAdminScope())) {
            Application scopeApp = (Application)((Object)this.getSession().get(Application.class, (Serializable)client.getApplication().getId()));
            if (this.getCurrentUser() == null || !this.getCurrentUser().equals((Object)scopeApp.getOwner())) {
                throw new BadRequestException();
            }
        }
        Session s = this.getSession();
        s.save((Object)client);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(ClientService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)client.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update client")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, Client client) {
        Session s = this.getSession();
        Client current = (Client)((Object)s.get(Client.class, (Serializable)id));
        this.assertCanAccess(current, this.getAdminScope());
        if (!current.equals((Object)client)) {
            throw new BadRequestException();
        }
        OAuthToken token = (OAuthToken)this.getSecurityContext().getUserPrincipal();
        if (token.getClient().equals((Object)client)) {
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        if (!current.getApplication().equals((Object)client.getApplication())) {
            throw new BadRequestException();
        }
        current.setName(client.getName());
        current.setType(client.getType());
        current.setClientSecret(client.getClientSecret());
        s.update((Object)current);
        return Response.ok((Object)((Object)client)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete client")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)id));
        this.assertCanAccess(client, this.getAdminScope());
        OAuthToken token = (OAuthToken)this.getSecurityContext().getUserPrincipal();
        if (token.getClient().equals((Object)client)) {
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        s.delete((Object)client);
        return Response.noContent().build();
    }

    @Path(value="/{clientId: [a-f0-9]{32}}/redirect")
    public Class<ClientRedirectService> getRedirectService(@ApiParam(type="string") @PathParam(value="clientId") BigInteger clientId) {
        return ClientRedirectService.class;
    }

    @Path(value="/{clientId: [a-f0-9]{32}}/referrer")
    public Class<ClientReferrerService> getReferrerService(@ApiParam(type="string") @PathParam(value="clientId") BigInteger clientId) {
        return ClientReferrerService.class;
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:client";
    }
}

