/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractClientUri;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientReferrer;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

@ScopesAllowed(value={"kangaroo:client", "kangaroo:client_admin"})
@Transactional
@Api(tags={"Client"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:client", description="Modify referrers in one application."), @AuthorizationScope(scope="kangaroo:client_admin", description="Modify referrers in all applications.")})})
public final class ClientReferrerService
extends AbstractService {
    private final BigInteger clientId;

    @Inject
    public ClientReferrerService(@ApiParam(type="string") @PathParam(value="clientId") BigInteger clientId) {
        this.clientId = clientId;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse client referrers")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        Criteria countCriteria = this.getSession().createCriteria(ClientReferrer.class).createAlias("client", "c").add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId())).setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(ClientReferrer.class).createAlias("client", "c").add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId())).setFirstResult(offset).setMaxResults(limit).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).addOrder(SortUtil.order(order, sort));
        browseCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId()));
        countCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId()));
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read client referrer")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        ClientReferrer referrer = (ClientReferrer)((Object)s.get(ClientReferrer.class, (Serializable)id));
        if (referrer == null || !referrer.getClient().equals((Object)client)) {
            throw new NotFoundException();
        }
        this.assertCanAccess(referrer, this.getAdminScope());
        return Response.ok((Object)((Object)referrer)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create client referrer")
    public Response createResource(ClientReferrer referrer) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccessSubresource(client, this.getAdminScope());
        if (referrer == null) {
            throw new BadRequestException();
        }
        if (referrer.getId() != null) {
            throw new BadRequestException();
        }
        if (referrer.getUri() == null) {
            throw new BadRequestException();
        }
        Boolean duplicate = client.getReferrers().stream().map(AbstractClientUri::getUri).anyMatch(uri -> uri.equals(referrer.getUri()));
        if (duplicate.booleanValue()) {
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        referrer.setClient(client);
        client.getReferrers().add(referrer);
        s.update((Object)client);
        s.save((Object)referrer);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(ClientReferrerService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)referrer.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update client referrer")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, ClientReferrer referrer) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        ClientReferrer currentReferrer = (ClientReferrer)((Object)s.get(ClientReferrer.class, (Serializable)id));
        if (currentReferrer == null) {
            throw new NotFoundException();
        }
        if (!currentReferrer.getClient().equals((Object)client)) {
            throw new NotFoundException();
        }
        if (!currentReferrer.equals((Object)referrer)) {
            throw new BadRequestException();
        }
        if (referrer.getUri() == null) {
            throw new BadRequestException();
        }
        Boolean duplicate = client.getReferrers().stream().filter(r -> !currentReferrer.equals(r)).anyMatch(r -> r.getUri().equals(referrer.getUri()));
        if (duplicate.booleanValue()) {
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        currentReferrer.setUri(referrer.getUri());
        s.update((Object)currentReferrer);
        return Response.ok((Object)((Object)referrer)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete client referrer")
    public Response deleteResource(@PathParam(value="id") BigInteger referrerId) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        ClientReferrer referrer = (ClientReferrer)((Object)s.get(ClientReferrer.class, (Serializable)referrerId));
        if (referrer == null) {
            throw new NotFoundException();
        }
        if (!referrer.getClient().equals((Object)client)) {
            throw new NotFoundException();
        }
        if (this.getAdminApplication().equals((Object)client.getApplication())) {
            throw new ForbiddenException();
        }
        client.getReferrers().remove((Object)referrer);
        s.delete((Object)referrer);
        s.update((Object)client);
        return Response.noContent().build();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:client";
    }
}

