/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractClientUri;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

@ScopesAllowed(value={"kangaroo:client", "kangaroo:client_admin"})
@Transactional
@Api(tags={"Client"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:client", description="Modify redirects in one application."), @AuthorizationScope(scope="kangaroo:client_admin", description="Modify redirects in all applications.")})})
public final class ClientRedirectService
extends AbstractService {
    private final BigInteger clientId;

    @Inject
    public ClientRedirectService(@ApiParam(type="string") @PathParam(value="clientId") BigInteger clientId) {
        this.clientId = clientId;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse client redirects")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        Criteria countCriteria = this.getSession().createCriteria(ClientRedirect.class).createAlias("client", "c").add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId())).setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(ClientRedirect.class).createAlias("client", "c").add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId())).setFirstResult(offset).setMaxResults(limit).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).addOrder(SortUtil.order(order, sort));
        browseCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId()));
        countCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)client.getId()));
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read client redirect")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        ClientRedirect redirect = (ClientRedirect)((Object)s.get(ClientRedirect.class, (Serializable)id));
        if (redirect == null || !redirect.getClient().equals((Object)client)) {
            throw new NotFoundException();
        }
        this.assertCanAccess(redirect, this.getAdminScope());
        return Response.ok((Object)((Object)redirect)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create client redirect")
    public Response createResource(ClientRedirect redirect) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccessSubresource(client, this.getAdminScope());
        if (redirect == null) {
            throw new BadRequestException();
        }
        if (redirect.getId() != null) {
            throw new BadRequestException();
        }
        if (redirect.getUri() == null) {
            throw new BadRequestException();
        }
        Boolean duplicate = client.getRedirects().stream().map(AbstractClientUri::getUri).anyMatch(uri -> uri.equals(redirect.getUri()));
        if (duplicate.booleanValue()) {
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        redirect.setClient(client);
        client.getRedirects().add(redirect);
        s.update((Object)client);
        s.save((Object)redirect);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(ClientRedirectService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)redirect.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update client redirect")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, ClientRedirect redirect) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        ClientRedirect currentRedirect = (ClientRedirect)((Object)s.get(ClientRedirect.class, (Serializable)id));
        if (currentRedirect == null) {
            throw new NotFoundException();
        }
        if (!currentRedirect.getClient().equals((Object)client)) {
            throw new NotFoundException();
        }
        if (!currentRedirect.equals((Object)redirect)) {
            throw new BadRequestException();
        }
        if (redirect.getUri() == null) {
            throw new BadRequestException();
        }
        Boolean duplicate = client.getRedirects().stream().filter(r -> !currentRedirect.equals(r)).anyMatch(r -> r.getUri().equals(redirect.getUri()));
        if (duplicate.booleanValue()) {
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        currentRedirect.setUri(redirect.getUri());
        s.update((Object)currentRedirect);
        return Response.ok((Object)((Object)redirect)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete client redirect")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger redirectId) {
        Session s = this.getSession();
        Client client = (Client)((Object)s.get(Client.class, (Serializable)this.clientId));
        this.assertCanAccess(client, this.getAdminScope());
        ClientRedirect redirect = (ClientRedirect)((Object)s.get(ClientRedirect.class, (Serializable)redirectId));
        if (redirect == null) {
            throw new NotFoundException();
        }
        if (!redirect.getClient().equals((Object)client)) {
            throw new NotFoundException();
        }
        if (this.getAdminApplication().equals((Object)client.getApplication())) {
            throw new ForbiddenException();
        }
        client.getRedirects().remove((Object)redirect);
        s.delete((Object)redirect);
        s.update((Object)client);
        return Response.noContent().build();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:client_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:client";
    }
}

