/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/authenticator")
@ScopesAllowed(value={"kangaroo:authenticator", "kangaroo:authenticator_admin"})
@Transactional
@Api(tags={"Authenticator"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:authenticator", description="Modify authenticators in one application."), @AuthorizationScope(scope="kangaroo:authenticator_admin", description="Modify authenticators in all applications.")})})
public final class AuthenticatorService
extends AbstractService {
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search authenticators")
    public Response search(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="10") @QueryParam(value="limit") Integer limit, @DefaultValue(value="") @QueryParam(value="q") String queryString, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="client") BigInteger clientId, @Optional @QueryParam(value="type") AuthenticatorType type) {
        Client filterByClient;
        QueryBuilder builder = this.getSearchFactory().buildQueryBuilder().forEntity(Authenticator.class).get();
        BooleanJunction junction = builder.bool();
        Query fuzzy = builder.keyword().fuzzy().onFields(new String[]{"client.name"}).matching((Object)queryString).createQuery();
        junction = junction.must(fuzzy);
        User owner = this.resolveOwnershipFilter(ownerId);
        if (owner != null) {
            Query ownerQuery = builder.keyword().onField("client.application.owner.id").matching((Object)owner.getId()).createQuery();
            junction.must(ownerQuery);
        }
        if ((filterByClient = this.resolveFilterEntity(Client.class, clientId)) != null) {
            Query userQuery = builder.keyword().onField("client.id").matching((Object)filterByClient.getId()).createQuery();
            junction.must(userQuery);
        }
        if (type != null) {
            Query typeQuery = builder.keyword().onField("type").matching((Object)type).createQuery();
            junction.must(typeQuery);
        }
        FullTextQuery query = this.getFullTextSession().createFullTextQuery(junction.createQuery(), new Class[]{Authenticator.class});
        return this.executeQuery(Authenticator.class, query, offset, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse authenticators")
    public Response browse(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId, @ApiParam(type="string") @Optional @QueryParam(value="client") BigInteger clientId) {
        User filterByOwner = this.resolveOwnershipFilter(ownerId);
        Client filterByClient = this.resolveFilterEntity(Client.class, clientId);
        Criteria countCriteria = this.getSession().createCriteria(Authenticator.class).createAlias("client", "c").setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(Authenticator.class).createAlias("client", "c").setFirstResult(offset).setMaxResults(limit).addOrder(SortUtil.order(order, sort));
        if (filterByClient != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)filterByClient.getId()));
            countCriteria.add((Criterion)Restrictions.eq((String)"c.id", (Object)filterByClient.getId()));
        }
        if (filterByOwner != null) {
            browseCriteria.createAlias("c.application", "a").createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
            countCriteria.createAlias("c.application", "a").createAlias("a.owner", "o").add((Criterion)Restrictions.eq((String)"o.id", (Object)filterByOwner.getId()));
        }
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read authenticator")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Authenticator authenticator = (Authenticator)((Object)this.getSession().get(Authenticator.class, (Serializable)id));
        this.assertCanAccess(authenticator, this.getAdminScope());
        return Response.ok((Object)((Object)authenticator)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create authenticator")
    public Response createResource(Authenticator authenticator) {
        if (authenticator == null) {
            throw new BadRequestException();
        }
        if (authenticator.getId() != null) {
            throw new BadRequestException();
        }
        if (authenticator.getClient() == null) {
            throw new BadRequestException();
        }
        if (authenticator.getType() == null) {
            throw new BadRequestException();
        }
        Client parent = (Client)((Object)this.getSession().get(Client.class, (Serializable)authenticator.getClient().getId()));
        if (parent == null) {
            throw new BadRequestException();
        }
        if (!this.getSecurityContext().isUserInRole(this.getAdminScope())) {
            Application scopeApp = parent.getApplication();
            if (this.getCurrentUser() == null || !this.getCurrentUser().equals((Object)scopeApp.getOwner())) {
                throw new BadRequestException();
            }
        }
        IAuthenticator handler = (IAuthenticator)this.getInjector().getInstance(IAuthenticator.class, authenticator.getType().toString());
        handler.validate(authenticator);
        Session s = this.getSession();
        s.save((Object)authenticator);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(AuthenticatorService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)authenticator.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update authenticator")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, Authenticator authenticator) {
        Session s = this.getSession();
        Authenticator current = (Authenticator)((Object)s.get(Authenticator.class, (Serializable)id));
        this.assertCanAccess(current, this.getAdminScope());
        if (!current.equals((Object)authenticator)) {
            throw new BadRequestException();
        }
        if (!current.getClient().equals((Object)authenticator.getClient())) {
            throw new BadRequestException();
        }
        if (authenticator.getType() == null) {
            throw new BadRequestException();
        }
        IAuthenticator handler = (IAuthenticator)this.getInjector().getInstance(IAuthenticator.class, authenticator.getType().toString());
        handler.validate(authenticator);
        current.setType(authenticator.getType());
        current.setConfiguration(authenticator.getConfiguration());
        s.update((Object)current);
        return Response.ok((Object)((Object)current)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete authenticator")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        Authenticator authenticator = (Authenticator)((Object)s.get(Authenticator.class, (Serializable)id));
        this.assertCanAccess(authenticator, this.getAdminScope());
        s.delete((Object)authenticator);
        return Response.noContent().build();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:authenticator_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:authenticator";
    }
}

