/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.resource.AbstractService;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.util.SortUtil;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import net.krotscheck.kangaroo.common.response.SortOrder;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/application")
@ScopesAllowed(value={"kangaroo:application", "kangaroo:application_admin"})
@Transactional
@Api(tags={"Application"}, authorizations={@Authorization(value="Kangaroo", scopes={@AuthorizationScope(scope="kangaroo:application", description="Modify one application."), @AuthorizationScope(scope="kangaroo:application_admin", description="Modify all applications.")})})
public final class ApplicationService
extends AbstractService {
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search applications")
    public Response search(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="10") @QueryParam(value="limit") Integer limit, @DefaultValue(value="") @QueryParam(value="q") String queryString, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId) {
        QueryBuilder builder = this.getSearchFactory().buildQueryBuilder().forEntity(Application.class).get();
        BooleanJunction junction = builder.bool();
        Query fuzzy = builder.keyword().fuzzy().onFields(new String[]{"name"}).matching((Object)queryString).createQuery();
        junction = junction.must(fuzzy);
        User owner = this.resolveOwnershipFilter(ownerId);
        if (owner != null) {
            Query ownerQuery = builder.keyword().onField("owner.id").matching((Object)owner.getId()).createQuery();
            junction.must(ownerQuery);
        }
        FullTextQuery query = this.getFullTextSession().createFullTextQuery(junction.createQuery(), new Class[]{Application.class});
        return this.executeQuery(Application.class, query, offset, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Browse applications")
    public Response browseApplications(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="sort") @DefaultValue(value="createdDate") String sort, @QueryParam(value="order") @DefaultValue(value="ASC") SortOrder order, @ApiParam(type="string") @Optional @QueryParam(value="owner") BigInteger ownerId) {
        User owner = this.resolveOwnershipFilter(ownerId);
        Criteria countCriteria = this.getSession().createCriteria(Application.class);
        countCriteria.setProjection(Projections.rowCount());
        Criteria browseCriteria = this.getSession().createCriteria(Application.class);
        browseCriteria.setFirstResult(offset);
        browseCriteria.setMaxResults(limit);
        browseCriteria.addOrder(SortUtil.order(order, sort));
        if (owner != null) {
            browseCriteria.add((Criterion)Restrictions.eq((String)"owner", (Object)((Object)owner)));
            countCriteria.add((Criterion)Restrictions.eq((String)"owner", (Object)((Object)owner)));
        }
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).order(order).sort(sort).total(countCriteria.uniqueResult()).addResult(browseCriteria.list()).build();
    }

    @GET
    @Path(value="/{id: [a-f0-9]{32}}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read application")
    public Response getResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Application application = (Application)((Object)this.getSession().get(Application.class, (Serializable)id));
        this.assertCanAccess(application, this.getAdminScope());
        return Response.ok((Object)((Object)application)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create application")
    public Response createResource(Application application) {
        if (application == null) {
            throw new BadRequestException();
        }
        if (application.getId() != null) {
            throw new BadRequestException();
        }
        if (application.getOwner() != null) {
            if (!this.getSecurityContext().isUserInRole(this.getAdminScope()) && !application.getOwner().equals((Object)this.getCurrentUser())) {
                throw new BadRequestException();
            }
        } else {
            if (this.getCurrentUser() == null) {
                throw new BadRequestException();
            }
            application.setOwner(this.getCurrentUser());
        }
        Session s = this.getSession();
        s.save((Object)application);
        URI resourceLocation = this.getUriInfo().getAbsolutePathBuilder().path(ApplicationService.class, "getResource").build(new Object[]{IdUtil.toString((BigInteger)application.getId())});
        return Response.created((URI)resourceLocation).build();
    }

    @PUT
    @Path(value="/{id: [a-f0-9]{32}}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update application")
    public Response updateResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id, Application application) {
        Session s = this.getSession();
        Application currentApp = (Application)((Object)s.get(Application.class, (Serializable)id));
        this.assertCanAccess(currentApp, this.getAdminScope());
        if (currentApp.equals((Object)this.getAdminApplication())) {
            throw new ForbiddenException();
        }
        if (!currentApp.equals((Object)application)) {
            throw new BadRequestException();
        }
        if (!currentApp.getOwner().equals((Object)application.getOwner())) {
            throw new BadRequestException();
        }
        if (!Objects.equals((Object)currentApp.getDefaultRole(), (Object)application.getDefaultRole())) {
            if (application.getDefaultRole() == null) {
                throw new BadRequestException();
            }
            Role resolveDesired = (Role)((Object)s.get(Role.class, (Serializable)application.getDefaultRole().getId()));
            if (resolveDesired == null || !Objects.equals((Object)resolveDesired.getApplication(), (Object)application)) {
                throw new BadRequestException();
            }
        }
        currentApp.setName(application.getName());
        s.update((Object)currentApp);
        return Response.ok((Object)((Object)application)).build();
    }

    @DELETE
    @Path(value="/{id: [a-f0-9]{32}}")
    @ApiOperation(value="Delete application")
    public Response deleteResource(@ApiParam(type="string") @PathParam(value="id") BigInteger id) {
        Session s = this.getSession();
        Application a = (Application)((Object)s.get(Application.class, (Serializable)id));
        this.assertCanAccess(a, this.getAdminScope());
        if (a.equals((Object)this.getAdminApplication())) {
            throw new ForbiddenException();
        }
        s.delete((Object)a);
        return Response.noContent().build();
    }

    @Override
    protected String getAdminScope() {
        return "kangaroo:application_admin";
    }

    @Override
    protected String getAccessScope() {
        return "kangaroo:application";
    }
}

