/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.resource;

import java.io.Serializable;
import java.math.BigInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.response.ListResponseBuilder;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchFactory;

public abstract class AbstractService {
    @Inject
    private InjectionManager injector;
    @Inject
    @Named(value="kangaroo-servlet-admin")
    private Configuration config;
    @Inject
    private Session session;
    @Inject
    private SearchFactory searchFactory;
    @Inject
    private FullTextSession fullTextSession;
    @Inject
    private SecurityContext securityContext;
    @Inject
    private UriInfo uriInfo;

    public final InjectionManager getInjector() {
        return this.injector;
    }

    public final void setInjector(InjectionManager injector) {
        this.injector = injector;
    }

    public final UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public final void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public final Session getSession() {
        return this.session;
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    public final SearchFactory getSearchFactory() {
        return this.searchFactory;
    }

    public final void setSearchFactory(SearchFactory searchFactory) {
        this.searchFactory = searchFactory;
    }

    public final FullTextSession getFullTextSession() {
        return this.fullTextSession;
    }

    public final void setFullTextSession(FullTextSession fullTextSession) {
        this.fullTextSession = fullTextSession;
    }

    public final Configuration getConfig() {
        return this.config;
    }

    public final void setConfig(Configuration config) {
        this.config = config;
    }

    public final SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public final void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    protected final User getCurrentUser() {
        OAuthToken t = (OAuthToken)this.securityContext.getUserPrincipal();
        if (t.getIdentity() != null) {
            return t.getIdentity().getUser();
        }
        return null;
    }

    protected abstract String getAdminScope();

    protected abstract String getAccessScope();

    protected final Application getAdminApplication() {
        Session s = this.getSession();
        String configId = this.config.getString("application_id");
        BigInteger appId = IdUtil.fromString((String)configId);
        return (Application)((Object)s.get(Application.class, (Serializable)appId));
    }

    protected final void assertCanAccess(AbstractAuthzEntity entity, String requiredScope) {
        if (entity == null) {
            throw new NotFoundException();
        }
        User u = this.getCurrentUser();
        if (u != null && u.equals((Object)entity.getOwner())) {
            return;
        }
        if (this.getSecurityContext().isUserInRole(requiredScope)) {
            return;
        }
        throw new NotFoundException();
    }

    protected final void assertCanAccessSubresource(AbstractAuthzEntity entity, String requiredParentScope) {
        if (entity == null) {
            throw new NotFoundException();
        }
        try {
            this.assertCanAccess(entity, requiredParentScope);
        }
        catch (NotFoundException e) {
            throw new BadRequestException();
        }
    }

    protected final User resolveOwnershipFilter(BigInteger ownerId) {
        String adminScope = this.getAdminScope();
        if (this.getSecurityContext().isUserInRole(adminScope)) {
            if (ownerId == null) {
                return null;
            }
            User owner = (User)((Object)this.getSession().get(User.class, (Serializable)ownerId));
            if (owner == null) {
                throw new BadRequestException();
            }
            return owner;
        }
        User currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new RFC6749.InvalidScopeException();
        }
        if (ownerId != null && !currentUser.getId().equals(ownerId)) {
            throw new RFC6749.InvalidScopeException();
        }
        return currentUser;
    }

    protected final <T extends AbstractAuthzEntity> T resolveFilterEntity(Class<T> roleClass, BigInteger entityId) {
        String ownerScope = this.getAccessScope();
        String adminScope = this.getAdminScope();
        T entity = this.resolveEntityInput(roleClass, entityId);
        if (this.getSecurityContext().isUserInRole(adminScope)) {
            return entity;
        }
        if (!this.getSecurityContext().isUserInRole(ownerScope)) {
            throw new RFC6749.InvalidScopeException();
        }
        User currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new RFC6749.InvalidScopeException();
        }
        if (entityId == null) {
            return null;
        }
        if (!currentUser.equals((Object)((AbstractAuthzEntity)((Object)entity)).getOwner())) {
            throw new BadRequestException();
        }
        return entity;
    }

    protected final Response executeQuery(Class<? extends AbstractEntity> klass, FullTextQuery query, int offset, int limit) {
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return ListResponseBuilder.builder().offset((Number)offset).limit((Number)limit).addResult(query.list()).total((Number)query.getResultSize()).build();
    }

    protected final <K extends AbstractAuthzEntity> K resolveEntityInput(Class<K> requestedType, K entity) {
        if (entity == null) {
            return null;
        }
        return this.resolveEntityInput(requestedType, entity.getId());
    }

    protected final <K extends AbstractAuthzEntity> K resolveEntityInput(Class<K> requestedType, BigInteger entityId) {
        if (entityId == null) {
            return null;
        }
        AbstractAuthzEntity entity = (AbstractAuthzEntity)((Object)this.getSession().get(requestedType, (Serializable)entityId));
        if (entity == null) {
            throw new BadRequestException();
        }
        return (K)((Object)entity);
    }

    protected final <K extends AbstractAuthzEntity> K requireEntityInput(Class<K> requestedType, K entity) {
        K resolved = this.resolveEntityInput(requestedType, entity);
        if (resolved == null) {
            throw new BadRequestException();
        }
        return resolved;
    }
}

