/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth.filter;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.OAuth2ForbiddenException;

@Priority(value=2000)
public final class OAuth2AuthorizationFilter
implements ContainerRequestFilter {
    private final String[] scopesAllowed;

    public OAuth2AuthorizationFilter() {
        this(new String[0]);
    }

    public OAuth2AuthorizationFilter(String[] scopesAllowed) {
        this.scopesAllowed = scopesAllowed;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext context = requestContext.getSecurityContext();
        if (context == null) {
            throw new OAuth2ForbiddenException(requestContext.getUriInfo(), this.scopesAllowed);
        }
        long matchedScopes = Arrays.stream(this.scopesAllowed).filter(arg_0 -> ((SecurityContext)context).isUserInRole(arg_0)).count();
        if (matchedScopes == 0L) {
            throw new OAuth2ForbiddenException(requestContext.getUriInfo(), this.scopesAllowed);
        }
    }
}

