/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth.filter;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import net.krotscheck.kangaroo.authz.admin.v1.auth.OAuth2SecurityContext;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.OAuth2NotAuthorizedException;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Priority(value=1000)
public final class OAuth2AuthenticationFilter
implements ContainerRequestFilter {
    private final Provider<Session> sessionProvider;
    private final Provider<Configuration> configProvider;
    private final String[] scopesAllowed;

    public OAuth2AuthenticationFilter(Provider<Session> sessionProvider, Provider<Configuration> configProvider, String[] scopesAllowed) {
        this.scopesAllowed = scopesAllowed;
        this.sessionProvider = sessionProvider;
        this.configProvider = configProvider;
    }

    public void filter(ContainerRequestContext request) throws IOException {
        SecurityContext oldContext = request.getSecurityContext();
        if (oldContext == null) {
            throw new OAuth2NotAuthorizedException(request.getUriInfo(), this.scopesAllowed);
        }
        String header = request.getHeaderString("Authorization");
        BigInteger tokenId = this.getTokenIdFromHeader(header);
        Application a = this.loadAdminApplication();
        Session session = (Session)this.sessionProvider.get();
        session.getTransaction().begin();
        Criteria c = session.createCriteria(OAuthToken.class).createAlias("client", "c").createAlias("c.application", "a").add((Criterion)Restrictions.eq((String)"id", (Object)tokenId)).add((Criterion)Restrictions.eq((String)"a.id", (Object)a.getId())).add((Criterion)Restrictions.eq((String)"tokenType", (Object)((Object)OAuthTokenType.Bearer))).setMaxResults(1).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        OAuthToken token = (OAuthToken)c.uniqueResult();
        if (token == null || token.isExpired()) {
            session.getTransaction().commit();
            throw new OAuth2NotAuthorizedException(request.getUriInfo(), this.scopesAllowed);
        }
        OAuth2SecurityContext context = new OAuth2SecurityContext(token, true);
        request.setSecurityContext((SecurityContext)context);
        session.getTransaction().commit();
    }

    private BigInteger getTokenIdFromHeader(String header) {
        if (StringUtils.isEmpty((CharSequence)header)) {
            return null;
        }
        String[] token = header.split(" ");
        if (token.length != 2) {
            return null;
        }
        if (!token[0].equals("Bearer")) {
            return null;
        }
        try {
            return IdUtil.fromString((String)token[1]);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    private Application loadAdminApplication() {
        Configuration servletConfig = (Configuration)this.configProvider.get();
        String idString = servletConfig.getString("application_id");
        BigInteger appId = IdUtil.fromString((String)idString);
        Session s = (Session)this.sessionProvider.get();
        return (Application)((Object)s.get(Application.class, (Serializable)appId));
    }
}

