/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth.exception;

import java.util.ArrayList;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import net.krotscheck.kangaroo.authz.admin.v1.auth.exception.WWWChallengeException;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;

public final class WWWChallengeExceptionMapper
implements ExceptionMapper<WWWChallengeException> {
    public Response toResponse(WWWChallengeException exception) {
        String authHeader = this.buildAuthHeader(exception);
        return ErrorResponseBuilder.from((KangarooException)exception).addHeader("WWW-Authenticate", authHeader).build();
    }

    private String buildAuthHeader(WWWChallengeException exception) {
        KangarooException.ErrorCode code = exception.getCode();
        String realm = exception.getRealm().toString();
        String scopes = String.join((CharSequence)" ", exception.getRequiredScopes());
        String error = code.getError();
        String description = code.getErrorDescription();
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(String.format("realm=\"%s\"", realm));
        entries.add(String.format("scope=\"%s\"", scopes));
        entries.add(String.format("error=\"%s\"", error));
        entries.add(String.format("error_description=\"%s\"", description));
        return String.format("Bearer %s", String.join((CharSequence)", ", entries));
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(WWWChallengeExceptionMapper.class).to(ExceptionMapper.class)).in(Singleton.class);
        }
    }
}

