/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth;

import java.security.Principal;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;

public final class OAuth2SecurityContext
implements SecurityContext {
    private final boolean secure;
    private final OAuthToken principal;
    private final Set<String> scopes;

    public OAuth2SecurityContext(OAuthToken token, Boolean isSecure) {
        this.principal = token;
        this.scopes = token.getScopes().keySet();
        this.secure = isSecure;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String roleName) {
        return this.scopes.contains(roleName);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAuthenticationScheme() {
        return "OAuth2";
    }
}

