/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin.v1.auth;

import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import net.krotscheck.kangaroo.authz.admin.v1.auth.ScopesAllowed;
import net.krotscheck.kangaroo.authz.admin.v1.auth.filter.OAuth2AuthenticationFilter;
import net.krotscheck.kangaroo.authz.admin.v1.auth.filter.OAuth2AuthorizationFilter;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.hibernate.Session;

final class OAuth2ScopeDynamicFeature
implements DynamicFeature {
    private final Provider<Session> sessionProvider;
    private final Provider<Configuration> configProvider;

    @Inject
    OAuth2ScopeDynamicFeature(Provider<Session> sessionProvider, @Named(value="kangaroo-servlet-admin") Provider<Configuration> configProvider) {
        this.sessionProvider = sessionProvider;
        this.configProvider = configProvider;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        if (am.isAnnotationPresent(DenyAll.class)) {
            configuration.register((Object)new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, new String[0]));
            configuration.register((Object)new OAuth2AuthorizationFilter());
            return;
        }
        ScopesAllowed ra = (ScopesAllowed)am.getAnnotation(ScopesAllowed.class);
        if (ra != null) {
            configuration.register((Object)new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, ra.value()));
            configuration.register((Object)new OAuth2AuthorizationFilter(ra.value()));
            return;
        }
        if (am.isAnnotationPresent(PermitAll.class)) {
            return;
        }
        ra = resourceInfo.getResourceClass().getAnnotation(ScopesAllowed.class);
        if (ra != null) {
            configuration.register((Object)new OAuth2AuthenticationFilter(this.sessionProvider, this.configProvider, ra.value()));
            configuration.register((Object)new OAuth2AuthorizationFilter(ra.value()));
        }
    }
}

