/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.krotscheck.kangaroo.authz.common.database.entity.AbstractAuthzEntity;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;

public final class Scope {
    public static final String USER = "kangaroo:user";
    public static final String USER_ADMIN = "kangaroo:user_admin";
    public static final String APPLICATION = "kangaroo:application";
    public static final String APPLICATION_ADMIN = "kangaroo:application_admin";
    public static final String AUTHENTICATOR = "kangaroo:authenticator";
    public static final String AUTHENTICATOR_ADMIN = "kangaroo:authenticator_admin";
    public static final String CLIENT = "kangaroo:client";
    public static final String CLIENT_ADMIN = "kangaroo:client_admin";
    public static final String IDENTITY = "kangaroo:identity";
    public static final String IDENTITY_ADMIN = "kangaroo:identity_admin";
    public static final String TOKEN = "kangaroo:token";
    public static final String TOKEN_ADMIN = "kangaroo:token_admin";
    public static final String ROLE = "kangaroo:role";
    public static final String ROLE_ADMIN = "kangaroo:role_admin";
    public static final String SCOPE = "kangaroo:scope";
    public static final String SCOPE_ADMIN = "kangaroo:scope_admin";

    private Scope() {
    }

    public static List<String> allScopes() {
        return Collections.unmodifiableList(Arrays.asList(APPLICATION, APPLICATION_ADMIN, AUTHENTICATOR, AUTHENTICATOR_ADMIN, CLIENT, CLIENT_ADMIN, IDENTITY, IDENTITY_ADMIN, ROLE, ROLE_ADMIN, USER, USER_ADMIN, SCOPE, SCOPE_ADMIN, TOKEN, TOKEN_ADMIN));
    }

    public static List<String> adminScopes() {
        return Collections.unmodifiableList(Arrays.asList(APPLICATION_ADMIN, AUTHENTICATOR_ADMIN, CLIENT_ADMIN, IDENTITY_ADMIN, ROLE_ADMIN, USER_ADMIN, SCOPE_ADMIN, TOKEN_ADMIN));
    }

    public static List<String> userScopes() {
        return Collections.unmodifiableList(Arrays.asList(APPLICATION, AUTHENTICATOR, CLIENT, IDENTITY, ROLE, USER, SCOPE, TOKEN));
    }

    public static String forEntity(AbstractAuthzEntity entity, Boolean admin) {
        if (entity instanceof Application) {
            return admin != false ? APPLICATION_ADMIN : APPLICATION;
        }
        if (entity instanceof Authenticator) {
            return admin != false ? AUTHENTICATOR_ADMIN : AUTHENTICATOR;
        }
        if (entity instanceof Client) {
            return admin != false ? CLIENT_ADMIN : CLIENT;
        }
        if (entity instanceof UserIdentity) {
            return admin != false ? IDENTITY_ADMIN : IDENTITY;
        }
        if (entity instanceof Role) {
            return admin != false ? ROLE_ADMIN : ROLE;
        }
        if (entity instanceof User) {
            return admin != false ? USER_ADMIN : USER;
        }
        if (entity instanceof ApplicationScope) {
            return admin != false ? SCOPE_ADMIN : SCOPE;
        }
        if (entity instanceof OAuthToken) {
            return admin != false ? TOKEN_ADMIN : TOKEN;
        }
        return "kangaroo:unknown";
    }
}

