/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz;

import java.io.IOException;
import net.krotscheck.kangaroo.authz.AuthzServerConfig;
import net.krotscheck.kangaroo.authz.admin.AdminV1API;
import net.krotscheck.kangaroo.authz.oauth2.OAuthAPI;
import net.krotscheck.kangaroo.server.ConfigurationBuilder;
import net.krotscheck.kangaroo.server.ServerFactory;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.Configuration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class AuthzServer {
    private static final Options CLI_OPTIONS;

    private AuthzServer() {
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Configuration config = new ConfigurationBuilder().withCommandlineOptions(CLI_OPTIONS).addCommandlineArgs(args).addPropertiesFile("kangaroo.authz.properties").build();
        Integer sessionMaxAge = config.getInt(AuthzServerConfig.SESSION_MAX_AGE.getKey(), AuthzServerConfig.SESSION_MAX_AGE.getValue().intValue());
        HttpServer server = new ServerFactory().withCommandlineOptions(CLI_OPTIONS).withCommandlineArgs(args).withPropertiesFile("kangaroo.authz.properties").withResource("/v1", (ResourceConfig)new AdminV1API()).withResource("/oauth2", (ResourceConfig)new OAuthAPI()).configureServer(s -> {
            ServerConfiguration c = s.getServerConfiguration();
            c.setSessionTimeoutSeconds(sessionMaxAge.intValue());
        }).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HttpServer)server).shutdownNow(), "shutdown"));
        server.start();
        Thread.currentThread().join();
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        CLI_OPTIONS = new Options();
        Option cookieName = Option.builder((String)"cn").longOpt(AuthzServerConfig.SESSION_NAME.getKey()).argName(AuthzServerConfig.SESSION_NAME.getKey()).hasArg().desc("The cookie name to use, default 'kangaroo'.").build();
        Option cookieExpiresIn = Option.builder((String)"ce").longOpt(AuthzServerConfig.SESSION_MAX_AGE.getKey()).argName(AuthzServerConfig.SESSION_MAX_AGE.getKey()).hasArg().desc("The maxium age of the cookie in seconds. Default 1 day.").build();
        CLI_OPTIONS.addOption(cookieName);
        CLI_OPTIONS.addOption(cookieExpiresIn);
    }
}

