/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.test;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Application;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.AuthenticatorState;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientRedirect;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientReferrer;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.HttpSession;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.Role;
import net.krotscheck.kangaroo.authz.common.database.entity.User;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.util.PasswordUtil;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;

public final class ApplicationBuilder {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final ApplicationContext context;
    private final List<AbstractEntity> trackedEntities = new ArrayList<AbstractEntity>();

    private ApplicationBuilder(ApplicationContext context) {
        this.context = context;
    }

    private ApplicationBuilder(Session session, Application application) {
        this.context = new ApplicationContext(session);
        this.context.application = application;
        this.persist((AbstractEntity)application);
    }

    public static ApplicationBuilder newApplication(Session session) {
        return ApplicationBuilder.newApplication(session, IdUtil.toString((BigInteger)IdUtil.next()));
    }

    public static ApplicationBuilder newApplication(Session session, String name) {
        Application application = new Application();
        application.setName(name);
        return ApplicationBuilder.newApplication(session, application);
    }

    public static ApplicationBuilder newApplication(Session session, Application application) {
        return new ApplicationBuilder(session, application);
    }

    public static ApplicationBuilder fromApplication(Session session, BigInteger id) {
        session.getTransaction().begin();
        Application application = (Application)session.get(Application.class, (Serializable)id);
        SortedMap scopes = application.getScopes();
        ApplicationScope scope = (ApplicationScope)scopes.values().iterator().next();
        Client client = (Client)application.getClients().get(0);
        List clients = application.getClients().stream().flatMap(c -> c.getTokens().stream()).map(OAuthToken::getClient).collect(Collectors.toList());
        if (clients.size() > 0) {
            client = (Client)clients.get(0);
        }
        Authenticator authenticator = (Authenticator)client.getAuthenticators().get(0);
        User user = (User)application.getUsers().get(0);
        Role role = null;
        if (application.getRoles().size() > 0) {
            role = (Role)application.getRoles().get(0);
        }
        UserIdentity userIdentity = null;
        if (user.getIdentities().size() > 0) {
            userIdentity = (UserIdentity)user.getIdentities().get(0);
        }
        OAuthToken token = null;
        if (client.getTokens().size() > 0) {
            token = (OAuthToken)client.getTokens().get(0);
        }
        session.getTransaction().commit();
        ApplicationContext context = new ApplicationContext(session);
        context.application = application;
        context.scopes.putAll(scopes);
        context.scope = scope;
        context.client = client;
        context.authenticator = authenticator;
        context.role = role;
        context.userIdentity = userIdentity;
        context.token = token;
        return new ApplicationBuilder(context);
    }

    public ApplicationContext getContext() {
        return this.context.copy();
    }

    public ApplicationBuilder role(String name) {
        ArrayList<String> scopeNames = new ArrayList<String>();
        if (this.context.scope != null) {
            scopeNames.add(this.context.scope.getName());
        }
        return this.role(name, scopeNames);
    }

    public ApplicationBuilder role(String name, String[] scopes) {
        return this.role(name, new ArrayList<String>(Arrays.asList(scopes)));
    }

    public ApplicationBuilder role(String name, List<String> scopeNames) {
        this.context.role = new Role();
        this.context.role.setName(name);
        this.context.role.setApplication(this.context.application);
        for (String scopeName : scopeNames) {
            if (!this.context.scopes.containsKey(scopeName)) continue;
            ApplicationScope scope = (ApplicationScope)this.context.scopes.get(scopeName);
            this.context.role.getScopes().put(scopeName, scope);
        }
        this.persist((AbstractEntity)this.context.role);
        if (this.context.application.getDefaultRole() == null) {
            this.context.application.setDefaultRole(this.context.role);
            this.persist((AbstractEntity)this.context.application);
        }
        return this;
    }

    public ApplicationBuilder scope(String name) {
        this.context.scope = new ApplicationScope();
        this.context.scope.setName(name);
        this.context.scopes.put(name, this.context.scope);
        this.context.scope.setApplication(this.context.application);
        this.persist((AbstractEntity)this.context.scope);
        return this;
    }

    public ApplicationBuilder scopes(List<String> scopes) {
        for (String scope : scopes) {
            this.scope(scope);
        }
        return this;
    }

    public ApplicationBuilder client(ClientType type) {
        return this.client(type, false);
    }

    public ApplicationBuilder client(ClientType type, String name) {
        return this.client(type, name, false);
    }

    public ApplicationBuilder client(ClientType type, Boolean isPrivate) {
        return this.client(type, "Test Client", isPrivate);
    }

    public ApplicationBuilder client(ClientType type, String name, Boolean isPrivate) {
        this.context.client = new Client();
        this.context.client.setName(name);
        this.context.client.setType(type);
        this.context.client.setApplication(this.context.application);
        if (isPrivate.booleanValue()) {
            this.context.client.setClientSecret(IdUtil.toString((BigInteger)IdUtil.next()));
        }
        this.persist((AbstractEntity)this.context.client);
        return this;
    }

    public ApplicationBuilder redirect() {
        String rawUrl = String.format("http://%s/redirect", RandomStringUtils.randomAlphabetic((int)10));
        return this.redirect(rawUrl);
    }

    public ApplicationBuilder redirect(String redirect) {
        this.context.redirect = new ClientRedirect();
        this.context.redirect.setClient(this.context.client);
        this.context.redirect.setUri(UriBuilder.fromUri((String)redirect).build(new Object[0]));
        this.persist((AbstractEntity)this.context.redirect);
        return this;
    }

    public ApplicationBuilder referrer() {
        String rawUrl = String.format("http://%s/referrer", RandomStringUtils.randomAlphabetic((int)10));
        return this.referrer(rawUrl);
    }

    public ApplicationBuilder referrer(String referrer) {
        this.context.referrer = new ClientReferrer();
        this.context.referrer.setClient(this.context.client);
        this.context.referrer.setUri(UriBuilder.fromUri((String)referrer).build(new Object[0]));
        this.persist((AbstractEntity)this.context.referrer);
        return this;
    }

    public ApplicationBuilder authenticator(AuthenticatorType type) {
        this.context.authenticator = new Authenticator();
        this.context.authenticator.setType(type);
        this.context.authenticator.setClient(this.context.client);
        this.persist((AbstractEntity)this.context.authenticator);
        return this;
    }

    public ApplicationBuilder authenticator(AuthenticatorType type, Map<String, String> config) {
        this.context.authenticator = new Authenticator();
        this.context.authenticator.setType(type);
        this.context.authenticator.setClient(this.context.client);
        this.context.authenticator.setConfiguration(config);
        this.persist((AbstractEntity)this.context.authenticator);
        return this;
    }

    public ApplicationBuilder user() {
        return this.user(this.context.role);
    }

    public ApplicationBuilder user(Role role) {
        this.context.user = new User();
        this.context.user.setRole(role);
        this.context.user.setApplication(this.context.application);
        this.persist((AbstractEntity)this.context.user);
        return this;
    }

    public ApplicationBuilder login(String login, String password) {
        this.context.userIdentity = new UserIdentity();
        this.context.userIdentity.setRemoteId(login);
        this.context.userIdentity.setSalt(PasswordUtil.createSalt());
        this.context.userIdentity.setPassword(PasswordUtil.hash((String)password, (String)this.context.userIdentity.getSalt()));
        this.context.userIdentity.setUser(this.context.user);
        this.context.userIdentity.setType(this.context.authenticator.getType());
        this.context.user.getIdentities().add(this.context.userIdentity);
        this.persist((AbstractEntity)this.context.user);
        this.persist((AbstractEntity)this.context.userIdentity);
        return this;
    }

    public ApplicationBuilder identity(String remoteIdentity) {
        this.context.userIdentity = new UserIdentity();
        this.context.userIdentity.setRemoteId(remoteIdentity);
        this.context.userIdentity.setUser(this.context.user);
        this.context.userIdentity.setType(this.context.authenticator.getType());
        this.context.user.getIdentities().add(this.context.userIdentity);
        this.persist((AbstractEntity)this.context.user);
        this.persist((AbstractEntity)this.context.userIdentity);
        return this;
    }

    public ApplicationBuilder identity() {
        return this.identity(IdUtil.toString((BigInteger)IdUtil.next()));
    }

    public ApplicationBuilder authToken() {
        return this.token(OAuthTokenType.Authorization, false, null, this.context.redirect.getUri().toString(), null);
    }

    public ApplicationBuilder bearerToken() {
        return this.bearerToken((String[])null);
    }

    public ApplicationBuilder bearerToken(String scopes) {
        return this.token(OAuthTokenType.Bearer, false, scopes, null, null);
    }

    public ApplicationBuilder bearerToken(Client client, UserIdentity identity, String scopes) {
        return this.token(client, identity, OAuthTokenType.Bearer, false, scopes, null, null);
    }

    public ApplicationBuilder bearerToken(String ... scopes) {
        return this.token(OAuthTokenType.Bearer, false, scopes != null ? String.join((CharSequence)" ", scopes) : null, null, null);
    }

    public ApplicationBuilder bearerToken(Client client, String ... scopes) {
        return this.token(client, this.context.userIdentity, OAuthTokenType.Bearer, false, String.join((CharSequence)" ", scopes), null, null);
    }

    public ApplicationBuilder refreshToken() {
        String scopes = "";
        if (this.context.token != null) {
            scopes = String.join((CharSequence)" ", this.context.token.getScopes().keySet());
        }
        return this.token(OAuthTokenType.Refresh, false, scopes, null, this.context.token);
    }

    public ApplicationBuilder token(OAuthTokenType type, Boolean expired, String scopeString, String redirect, OAuthToken authToken) {
        return this.token(this.context.client, this.context.userIdentity, type, expired, scopeString, redirect, authToken);
    }

    public ApplicationBuilder token(Client client, UserIdentity identity, OAuthTokenType type, Boolean expired, String scopeString, String redirect, OAuthToken authToken) {
        this.context.token = new OAuthToken();
        this.context.token.setTokenType(type);
        this.context.token.setClient(client);
        this.context.token.setIssuer("localhost");
        if (authToken != null) {
            this.context.token.setAuthToken(authToken);
        }
        if (!this.context.token.getClient().getType().equals((Object)ClientType.ClientCredentials)) {
            this.context.token.setIdentity(identity);
        }
        if (!StringUtils.isEmpty((CharSequence)redirect)) {
            URI redirectUri = UriBuilder.fromUri((String)redirect).build(new Object[0]);
            this.context.token.setRedirect(redirectUri);
        }
        if (expired.booleanValue()) {
            this.context.token.setExpiresIn(-100);
        } else {
            this.context.token.setExpiresIn(100);
        }
        TreeMap newScopes = new TreeMap();
        SortedMap currentScopes = this.context.scopes;
        if (!StringUtils.isEmpty((CharSequence)scopeString)) {
            for (String scope : scopeString.split(" ")) {
                newScopes.put(scope, currentScopes.get(scope));
            }
        }
        this.context.token.setScopes(newScopes);
        this.persist((AbstractEntity)this.context.token);
        return this;
    }

    public ApplicationBuilder claim(String name, String value) {
        this.context.userIdentity.getClaims().putIfAbsent(name, value);
        this.persist((AbstractEntity)this.context.userIdentity);
        return this;
    }

    public ApplicationBuilder authenticatorState() {
        this.context.authenticatorState = new AuthenticatorState();
        this.context.authenticatorState.setClientRedirect(this.context.redirect.getUri());
        this.context.authenticatorState.setAuthenticator(this.context.authenticator);
        this.persist((AbstractEntity)this.context.authenticatorState);
        return this;
    }

    public ApplicationBuilder owner(User user) {
        this.context.application.setOwner(user);
        this.persist((AbstractEntity)this.context.application);
        return this;
    }

    public ApplicationBuilder httpSession(Boolean expired) {
        this.context.httpSession = new HttpSession();
        this.context.httpSession.setSessionTimeout(expired != false ? -100L : 100L);
        if (this.context.token != null && this.context.token.getTokenType().equals((Object)OAuthTokenType.Refresh)) {
            this.context.token.setHttpSession(this.context.httpSession);
        }
        this.persist((AbstractEntity)this.context.httpSession);
        if (this.context.token != null && this.context.httpSession.equals((Object)this.context.token.getHttpSession())) {
            this.persist((AbstractEntity)this.context.token);
        }
        return this;
    }

    public void persist(AbstractEntity e) {
        if (e.getCreatedDate() == null) {
            e.setCreatedDate(Calendar.getInstance(UTC));
        }
        e.setModifiedDate(Calendar.getInstance(UTC));
        if (!this.trackedEntities.contains(e)) {
            this.trackedEntities.add(e);
        }
    }

    public ApplicationContext build() {
        Session session = this.context.session;
        session.getTransaction().begin();
        for (AbstractEntity e : this.trackedEntities) {
            session.saveOrUpdate((Object)e);
        }
        session.getTransaction().commit();
        session.getTransaction().begin();
        for (AbstractEntity e : this.trackedEntities) {
            session.refresh((Object)e);
        }
        session.getTransaction().commit();
        return this.context.copy();
    }

    public static final class ApplicationContext {
        private final Session session;
        private HttpSession httpSession;
        private Application application;
        private ApplicationScope scope;
        private SortedMap<String, ApplicationScope> scopes = new TreeMap<String, ApplicationScope>();
        private AuthenticatorState authenticatorState;
        private Role role;
        private Client client;
        private Authenticator authenticator;
        private User user;
        private UserIdentity userIdentity;
        private OAuthToken token;
        private ClientRedirect redirect;
        private ClientReferrer referrer;

        private ApplicationContext(Session session) {
            this.session = session;
        }

        public ApplicationBuilder getBuilder() {
            return new ApplicationBuilder(this.copy());
        }

        public HttpSession getHttpSession() {
            return this.httpSession;
        }

        public String getHttpSessionId() {
            if (this.httpSession != null) {
                return IdUtil.toString((BigInteger)this.httpSession.getId());
            }
            return "";
        }

        public Application getApplication() {
            return this.application;
        }

        public Role getRole() {
            return this.role;
        }

        public SortedMap<String, ApplicationScope> getScopes() {
            return Collections.unmodifiableSortedMap(this.scopes);
        }

        public Client getClient() {
            return this.client;
        }

        public ClientRedirect getRedirect() {
            return this.redirect;
        }

        public ClientReferrer getReferrer() {
            return this.referrer;
        }

        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        public User getUser() {
            return this.user;
        }

        public UserIdentity getUserIdentity() {
            return this.userIdentity;
        }

        public OAuthToken getToken() {
            return this.token;
        }

        public ApplicationScope getScope() {
            return this.scope;
        }

        public User getOwner() {
            return this.getApplication().getOwner();
        }

        public AuthenticatorState getAuthenticatorState() {
            return this.authenticatorState;
        }

        protected ApplicationContext copy() {
            ApplicationContext snapshot = new ApplicationContext(this.session);
            snapshot.application = this.application;
            snapshot.client = this.client;
            snapshot.authenticator = this.authenticator;
            snapshot.scope = this.scope;
            snapshot.scopes = this.scopes;
            snapshot.authenticatorState = this.authenticatorState;
            snapshot.role = this.role;
            snapshot.user = this.user;
            snapshot.userIdentity = this.userIdentity;
            snapshot.token = this.token;
            snapshot.redirect = this.redirect;
            snapshot.referrer = this.referrer;
            snapshot.httpSession = this.httpSession;
            return snapshot;
        }
    }
}

