/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.session.tasks;

import java.sql.SQLException;
import java.util.TimerTask;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.session.tasks.HttpSessionCleanupTask;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.hibernate.type.Type;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class HttpSessionCleanupTaskTest
extends DatabaseTest {
    private static ApplicationBuilder.ApplicationContext context;
    @ClassRule
    public static final TestDataResource TEST_DATA_RESOURCE;

    @Test
    public void testGetTask() {
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(this.getSessionFactory(), null);
        TimerTask rTask = task.getTask();
        Assert.assertSame((Object)task, (Object)rTask);
    }

    @Test
    public void testSimpleRun() {
        ApplicationBuilder b = context.getBuilder();
        for (int i = 0; i < 10; ++i) {
            b.httpSession(i % 2 == 1);
        }
        b.build();
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(this.getSessionFactory(), null);
        TimerTask rTask = task.getTask();
        Query q = this.getSession().createQuery("SELECT count(id) from HttpSession");
        long startCount = (Long)q.uniqueResult();
        Assert.assertEquals((long)10L, (long)startCount);
        rTask.run();
        long count = (Long)q.uniqueResult();
        Assert.assertEquals((long)5L, (long)count);
        rTask.run();
        long secondCount = (Long)q.uniqueResult();
        Assert.assertEquals((long)5L, (long)secondCount);
    }

    @Test
    public void testRunWithError() {
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Session mockSession = (Session)Mockito.mock(Session.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        ((Query)Mockito.doReturn((Object)mockQuery).when((Object)mockQuery)).setParameter(Matchers.anyString(), Matchers.any(), (Type)Matchers.any(Type.class));
        ((Query)Mockito.doThrow(HibernateException.class).when((Object)mockQuery)).executeUpdate();
        ((Session)Mockito.doReturn((Object)mockQuery).when((Object)mockSession)).createQuery(Matchers.anyString());
        ((SessionFactory)Mockito.doReturn((Object)mockSession).when((Object)mockFactory)).openSession();
        ((Session)Mockito.doReturn((Object)mockTransaction).when((Object)mockSession)).beginTransaction();
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(mockFactory, null);
        TimerTask rTask = task.getTask();
        rTask.run();
        ((Transaction)Mockito.verify((Object)mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        ((Session)Mockito.verify((Object)mockSession, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test(expected=SQLException.class)
    public void testRunWithUnexpectedError() {
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Session mockSession = (Session)Mockito.mock(Session.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        ((Query)Mockito.doReturn((Object)mockQuery).when((Object)mockQuery)).setParameter(Matchers.anyString(), Matchers.any(), (Type)Matchers.any(Type.class));
        ((Query)Mockito.doThrow(SQLException.class).when((Object)mockQuery)).executeUpdate();
        ((Session)Mockito.doReturn((Object)mockQuery).when((Object)mockSession)).createQuery(Matchers.anyString());
        ((SessionFactory)Mockito.doReturn((Object)mockSession).when((Object)mockFactory)).openSession();
        ((Session)Mockito.doReturn((Object)mockTransaction).when((Object)mockSession)).beginTransaction();
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(mockFactory, null);
        TimerTask rTask = task.getTask();
        rTask.run();
        ((Transaction)Mockito.verify((Object)mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        ((Session)Mockito.verify((Object)mockSession, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void assertSessionClosedOnRollbackFailure() {
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Session mockSession = (Session)Mockito.mock(Session.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        ((Query)Mockito.doReturn((Object)mockQuery).when((Object)mockQuery)).setParameter(Matchers.anyString(), Matchers.any(), (Type)Matchers.any(Type.class));
        ((Query)Mockito.doReturn((Object)0).when((Object)mockQuery)).executeUpdate();
        ((Session)Mockito.doReturn((Object)mockQuery).when((Object)mockSession)).createQuery(Matchers.anyString());
        ((SessionFactory)Mockito.doReturn((Object)mockSession).when((Object)mockFactory)).openSession();
        ((Session)Mockito.doReturn((Object)mockTransaction).when((Object)mockSession)).beginTransaction();
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(mockFactory, null);
        TimerTask rTask = task.getTask();
        rTask.run();
        ((Transaction)Mockito.verify((Object)mockTransaction, (VerificationMode)Mockito.times((int)1))).commit();
        ((Session)Mockito.verify((Object)mockSession, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test(expected=HibernateException.class)
    public void assertSessionClosedErrorRethrown() {
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Session mockSession = (Session)Mockito.mock(Session.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        ((Query)Mockito.doReturn((Object)mockQuery).when((Object)mockQuery)).setParameter(Matchers.anyString(), Matchers.any(), (Type)Matchers.any(Type.class));
        ((Query)Mockito.doReturn((Object)0).when((Object)mockQuery)).executeUpdate();
        ((Session)Mockito.doReturn((Object)mockQuery).when((Object)mockSession)).createQuery(Matchers.anyString());
        ((SessionFactory)Mockito.doReturn((Object)mockSession).when((Object)mockFactory)).openSession();
        ((Session)Mockito.doReturn((Object)mockTransaction).when((Object)mockSession)).beginTransaction();
        ((Session)Mockito.doThrow(HibernateException.class).when((Object)mockSession)).close();
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(mockFactory, null);
        TimerTask rTask = task.getTask();
        rTask.run();
    }

    @Test
    public void getPeriod() {
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(this.getSessionFactory(), null);
        Assert.assertEquals((long)600000L, (long)task.getPeriod());
    }

    @Test
    public void getDelay() {
        HttpSessionCleanupTask task = new HttpSessionCleanupTask(this.getSessionFactory(), null);
        Assert.assertEquals((long)task.getPeriod(), (long)task.getDelay());
    }

    static {
        TEST_DATA_RESOURCE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).client(ClientType.Implicit).authenticator(AuthenticatorType.Test).user().identity().build();
            }
        };
    }
}

