/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.session.grizzly;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import net.krotscheck.kangaroo.authz.AuthzServerConfig;
import net.krotscheck.kangaroo.authz.common.database.entity.HttpSession;
import net.krotscheck.kangaroo.authz.oauth2.session.grizzly.GrizzlySessionManager;
import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class GrizzlySessionManagerTest
extends DatabaseTest {
    private GrizzlySessionManager manager;

    @Before
    public void setup() {
        SystemConfiguration config = new SystemConfiguration(Collections.emptyList());
        this.manager = new GrizzlySessionManager(config, () -> ((GrizzlySessionManagerTest)this).getSessionFactory());
    }

    @Test
    public void testCreateSession() {
        Session newSession = this.manager.createSession(null);
        org.hibernate.Session hSession = this.getSession();
        HttpSession dbSession = (HttpSession)hSession.get(HttpSession.class, (Serializable)IdUtil.fromString((String)newSession.getIdInternal()));
        this.ensureSessionsMatch(dbSession, newSession);
    }

    @Test
    public void testGetSession() {
        org.hibernate.Session hSession = this.getSession();
        HttpSession s = new HttpSession();
        s.setSessionTimeout(1000L);
        Calendar zero = Calendar.getInstance();
        zero.setTimeInMillis(0L);
        hSession.beginTransaction();
        hSession.save((Object)s);
        Query q = hSession.createQuery("update HttpSession set createdDate=?, modifiedDate=?");
        q.setParameter(0, (Object)zero);
        q.setParameter(1, (Object)zero);
        q.executeUpdate();
        hSession.evict((Object)s);
        hSession.getTransaction().commit();
        Session result = this.manager.getSession(null, IdUtil.toString((BigInteger)s.getId()));
        hSession.clear();
        hSession.beginTransaction();
        s = (HttpSession)hSession.get(HttpSession.class, (Serializable)s.getId());
        hSession.getTransaction().commit();
        Assert.assertTrue((s.getModifiedDate().getTimeInMillis() > 0L ? 1 : 0) != 0);
        this.ensureSessionsMatch(s, result);
    }

    @Test
    public void testGetSessionNoId() {
        Assert.assertNull((Object)this.manager.getSession(null, null));
    }

    @Test
    public void testNonexistentSession() {
        String testId = IdUtil.toString((BigInteger)IdUtil.next());
        Assert.assertNull((Object)this.manager.getSession(null, testId));
    }

    @Test
    public void testChangeSessionId() {
        org.hibernate.Session hSession = this.getSession();
        HttpSession s = new HttpSession();
        s.setSessionTimeout(1000L);
        hSession.beginTransaction();
        hSession.save((Object)s);
        hSession.getTransaction().commit();
        hSession.evict((Object)s);
        Session browserSession = this.manager.asSession(s);
        String oldId = this.manager.changeSessionId(null, browserSession);
        Assert.assertEquals((Object)s.getId(), (Object)IdUtil.fromString((String)oldId));
        hSession.beginTransaction();
        HttpSession testSession = (HttpSession)hSession.get(HttpSession.class, (Serializable)s.getId());
        hSession.getTransaction().commit();
        Assert.assertNull((Object)testSession);
        Assert.assertNotEquals((Object)oldId, (Object)browserSession.getIdInternal());
        hSession.beginTransaction();
        HttpSession newSession = (HttpSession)hSession.get(HttpSession.class, (Serializable)IdUtil.fromString((String)browserSession.getIdInternal()));
        hSession.getTransaction().commit();
        Assert.assertNotNull((Object)newSession);
        Assert.assertEquals((long)s.getSessionTimeout(), (long)newSession.getSessionTimeout());
        Assert.assertNotEquals((Object)s.getCreatedDate(), (Object)newSession.getCreatedDate());
        Assert.assertNotEquals((Object)s.getModifiedDate(), (Object)newSession.getModifiedDate());
    }

    @Test
    public void testChangeSessionIdNoOriginal() {
        HttpSession s = new HttpSession();
        s.setId(IdUtil.next());
        s.setCreatedDate(Calendar.getInstance());
        s.setModifiedDate(Calendar.getInstance());
        s.setSessionTimeout(1000L);
        Session browserSession = this.manager.asSession(s);
        String oldId = this.manager.changeSessionId(null, browserSession);
        Assert.assertEquals((Object)s.getId(), (Object)IdUtil.fromString((String)oldId));
    }

    @Test
    public void testChangeSessionIdThrown() {
        SystemConfiguration config = new SystemConfiguration(Collections.emptyList());
        SessionFactory mockFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        org.hibernate.Session mockHSession = (org.hibernate.Session)Mockito.mock(org.hibernate.Session.class);
        Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        ((SessionFactory)Mockito.doReturn((Object)mockHSession).when((Object)mockFactory)).openSession();
        ((org.hibernate.Session)Mockito.doReturn((Object)mockTransaction).when((Object)mockHSession)).getTransaction();
        ((org.hibernate.Session)Mockito.doThrow(HibernateException.class).when((Object)mockHSession)).beginTransaction();
        this.manager = new GrizzlySessionManager(config, () -> mockFactory);
        HttpSession s = new HttpSession();
        s.setId(IdUtil.next());
        s.setCreatedDate(Calendar.getInstance());
        s.setModifiedDate(Calendar.getInstance());
        s.setSessionTimeout(1000L);
        Session browserSession = this.manager.asSession(s);
        String oldId = this.manager.changeSessionId(null, browserSession);
        ((org.hibernate.Session)Mockito.verify((Object)mockHSession, (VerificationMode)Mockito.times((int)1))).close();
        ((Transaction)Mockito.verify((Object)mockTransaction, (VerificationMode)Mockito.times((int)1))).rollback();
        Assert.assertEquals((Object)s.getId(), (Object)IdUtil.fromString((String)oldId));
    }

    @Test
    public void testGetSetSessionCookieName() {
        String oldName = this.manager.getSessionCookieName();
        this.manager.setSessionCookieName("new_cookie_name");
        Assert.assertEquals((Object)"new_cookie_name", (Object)this.manager.getSessionCookieName());
        Assert.assertEquals((Object)"kangaroo", (Object)oldName);
    }

    @Test
    public void testAsSession() {
        Assert.assertNull((Object)this.manager.asSession(null));
        HttpSession s = new HttpSession();
        s.setId(IdUtil.next());
        s.setCreatedDate(Calendar.getInstance());
        s.setModifiedDate(Calendar.getInstance());
        s.setSessionTimeout(1000L);
        Session result = this.manager.asSession(s);
        this.ensureSessionsMatch(s, result);
    }

    @Test
    public void testConfigureSessionCookie() throws Exception {
        Request r = (Request)Mockito.mock(Request.class);
        ((Request)Mockito.doReturn((Object)new StringBuilder("http://example.com/foo")).when((Object)r)).getRequestURL();
        Cookie c = new Cookie("JSESSIONID", null);
        this.manager.configureSessionCookie(r, c);
        Assert.assertEquals((Object)"example.com", (Object)c.getDomain());
        Assert.assertEquals((long)1L, (long)c.getVersion());
        Assert.assertTrue((boolean)c.isHttpOnly());
        Assert.assertTrue((boolean)c.isSecure());
        Assert.assertEquals(AuthzServerConfig.SESSION_NAME.getValue(), (Object)c.getName());
        Assert.assertEquals(AuthzServerConfig.SESSION_MAX_AGE.getValue(), (Object)c.getMaxAge());
    }

    private void ensureSessionsMatch(HttpSession dbSession, Session browserSession) {
        Assert.assertEquals((Object)IdUtil.toString((BigInteger)dbSession.getId()), (Object)browserSession.getIdInternal());
        Assert.assertEquals((long)dbSession.getCreatedDate().getTimeInMillis(), (long)browserSession.getCreationTime());
        Assert.assertEquals((long)dbSession.getModifiedDate().getTimeInMillis(), (long)browserSession.getTimestamp());
        Assert.assertEquals((long)dbSession.getSessionTimeout(), (long)browserSession.getSessionTimeout());
    }
}

