/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.session.grizzly;

import java.util.Collections;
import javax.servlet.ServletContext;
import net.krotscheck.kangaroo.authz.AuthzServerConfig;
import net.krotscheck.kangaroo.authz.oauth2.session.grizzly.GrizzlySessionLifecycleListener;
import net.krotscheck.kangaroo.authz.oauth2.session.grizzly.GrizzlySessionManager;
import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.test.jersey.DatabaseTest;
import org.glassfish.grizzly.http.server.SessionManager;
import org.glassfish.grizzly.servlet.SessionCookieConfig;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.server.spi.Container;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class GrizzlySessionLifecycleListenerTest
extends DatabaseTest {
    private GrizzlySessionLifecycleListener listener;
    private Container mockContainer;
    private WebappContext context;
    private GrizzlySessionManager sessionManager;
    private SystemConfiguration configuration;

    @Before
    public void setupTest() {
        this.mockContainer = (Container)Mockito.mock(Container.class);
        this.context = (WebappContext)Mockito.mock(WebappContext.class);
        SessionCookieConfig config = new SessionCookieConfig(this.context);
        ((WebappContext)Mockito.doReturn((Object)config).when((Object)this.context)).getSessionCookieConfig();
        this.configuration = new SystemConfiguration(Collections.emptyList());
        this.sessionManager = new GrizzlySessionManager(this.configuration, () -> ((GrizzlySessionLifecycleListenerTest)this).getSessionFactory());
        this.listener = new GrizzlySessionLifecycleListener((ServletContext)this.context, this.sessionManager, this.configuration);
    }

    @Test
    public void onStartup() {
        this.listener.onStartup(this.mockContainer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockContainer});
        ((WebappContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.times((int)1))).setSessionManager((SessionManager)this.sessionManager);
    }

    @Test
    public void onStartupConfigureCookie() {
        this.listener.onStartup(this.mockContainer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockContainer});
        javax.servlet.SessionCookieConfig config = this.context.getSessionCookieConfig();
        Assert.assertTrue((boolean)config.isHttpOnly());
        Assert.assertTrue((boolean)config.isSecure());
        Assert.assertEquals((long)config.getMaxAge(), (long)((Integer)AuthzServerConfig.SESSION_MAX_AGE.getValue()).intValue());
        Assert.assertEquals((Object)config.getName(), AuthzServerConfig.SESSION_NAME.getValue());
    }

    @Test
    public void onReload() {
        this.listener.onReload(this.mockContainer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockContainer});
    }

    @Test
    public void onShutdown() {
        this.listener.onShutdown(this.mockContainer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockContainer});
    }
}

