/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.session;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.database.DatabaseFeature;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.oauth2.session.SessionFeature;
import net.krotscheck.kangaroo.authz.oauth2.session.tasks.HttpSessionCleanupTask;
import net.krotscheck.kangaroo.common.config.ConfigurationFeature;
import net.krotscheck.kangaroo.common.hibernate.HibernateFeature;
import net.krotscheck.kangaroo.common.timedtasks.RepeatingTask;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.jvnet.hk2.annotations.Optional;

public final class SessionFeatureTest
extends ContainerTest {
    protected ResourceConfig createApplication() {
        ResourceConfig a = new ResourceConfig();
        a.register(HibernateFeature.class);
        a.register(DatabaseFeature.class);
        a.register(ConfigurationFeature.class);
        a.register(SessionFeature.class);
        a.register(MockService.class);
        return a;
    }

    @Test
    public void testStatus() {
        Response response = this.target("/").request().get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Path(value="/")
    public static final class MockService {
        private Provider<HttpSession> httpSessionProvider;
        private Provider<RepeatingTask> taskProvider;
        private OAuthToken token;

        @Inject
        public MockService(Provider<HttpSession> httpSessionProvider, Provider<RepeatingTask> taskProvider, @Optional OAuthToken token) {
            this.taskProvider = taskProvider;
            this.httpSessionProvider = httpSessionProvider;
            this.token = token;
        }

        @GET
        @Produces(value={"application/json"})
        public Response status() {
            HttpSession session = (HttpSession)this.httpSessionProvider.get();
            if (session == null || this.token != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            RepeatingTask task = (RepeatingTask)this.taskProvider.get();
            if (task == null || !(task instanceof HttpSessionCleanupTask)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.status((int)200).build();
        }
    }
}

