/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.rfc7662;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.OAuthAPI;
import net.krotscheck.kangaroo.authz.oauth2.resource.IntrospectionResponseEntity;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.jersey.ContainerTest;
import net.krotscheck.kangaroo.test.jersey.SingletonTestContainerFactory;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import net.krotscheck.kangaroo.util.StringUtil;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class TokenIntrospectionTest
extends ContainerTest {
    private static ApplicationBuilder.ApplicationContext context;
    private static String contextAuthHeader;
    private static ApplicationBuilder.ApplicationContext otherContext;
    private static String otherContextAuthHeader;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;
    private SingletonTestContainerFactory testContainerFactory;
    private ResourceConfig testApplication;

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = new SingletonTestContainerFactory(super.getTestContainerFactory(), ((Object)((Object)this)).getClass());
        }
        return this.testContainerFactory;
    }

    protected ResourceConfig createApplication() {
        if (this.testApplication == null) {
            this.testApplication = new OAuthAPI();
        }
        return this.testApplication;
    }

    private Entity buildEntity(Map<String, String> values) {
        Form f = new Form();
        values.forEach((arg_0, arg_1) -> ((Form)f).param(arg_0, arg_1));
        return Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private void assertInactiveIntrospectionResponse(Response r) {
        Assert.assertEquals((long)200L, (long)r.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)r.getMediaType().toString());
        IntrospectionResponseEntity entity = (IntrospectionResponseEntity)r.readEntity(IntrospectionResponseEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)entity.isActive());
        Assert.assertNull((Object)entity.getClientId());
        Assert.assertNull((Object)entity.getTokenType());
        Assert.assertNull((Object)entity.getIat());
        Assert.assertNull((Object)entity.getJti());
        Assert.assertNull((Object)entity.getNbf());
        Assert.assertNull((Object)entity.getAud());
        Assert.assertNull((Object)entity.getIss());
        Assert.assertNull((Object)entity.getScope());
        Assert.assertNull((Object)entity.getSub());
    }

    private void assertSuccessfulIntrospectionResponse(Response r, OAuthToken token) {
        Assert.assertEquals((long)200L, (long)r.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)r.getMediaType().toString());
        IntrospectionResponseEntity entity = (IntrospectionResponseEntity)r.readEntity(IntrospectionResponseEntity.class);
        Assert.assertNotNull((Object)entity);
        Calendar created = (Calendar)token.getCreatedDate().clone();
        created.set(14, 0);
        Assert.assertEquals((Object)token.getClient().getId(), (Object)entity.getClientId());
        Assert.assertEquals((Object)token.getTokenType(), (Object)entity.getTokenType());
        Assert.assertEquals((Object)created, (Object)entity.getIat());
        Assert.assertEquals((Object)(!token.isExpired() ? 1 : 0), (Object)entity.isActive());
        Assert.assertEquals((Object)token.getId(), (Object)entity.getJti());
        Assert.assertEquals((Object)created, (Object)entity.getNbf());
        Assert.assertEquals((Object)token.getClient().getApplication().getId(), (Object)entity.getAud());
        Calendar expires = (Calendar)created.clone();
        expires.add(13, token.getExpiresIn().intValue());
        Assert.assertEquals((Object)expires, (Object)entity.getExp());
        Assert.assertEquals((Object)"localhost", (Object)entity.getIss());
        String scopes = StringUtil.sameOrDefault((String)entity.getScope(), (String)"");
        List<String> scopeList = Arrays.asList(scopes.split(" "));
        ArrayList tokenScopes = new ArrayList(token.getScopes().keySet());
        Assert.assertEquals(scopeList, tokenScopes);
        if (token.getClient().getType().equals((Object)ClientType.ClientCredentials)) {
            Assert.assertNull((Object)token.getIdentity());
            Assert.assertEquals((Object)token.getClient().getId(), (Object)entity.getSub());
        } else {
            Assert.assertNotNull((Object)token.getIdentity());
            Assert.assertEquals((Object)token.getIdentity().getRemoteId(), (Object)entity.getUsername());
            Assert.assertEquals((Object)token.getIdentity().getUser().getId(), (Object)entity.getSub());
        }
    }

    @Test
    public void testTokenIntrospectSelf() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = testContext.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)bearerToken.getId());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)bearerToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertSuccessfulIntrospectionResponse(r, bearerToken);
    }

    @Test
    public void testTokenIntrospectByOtherToken() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = testContext.getToken();
        ApplicationBuilder.ApplicationContext testContext2 = context.getBuilder().bearerToken().build();
        OAuthToken bearerToken2 = testContext2.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)bearerToken2.getId());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)bearerToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testAuthCodeIntrospect() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = testContext.getToken();
        ApplicationBuilder.ApplicationContext testContext2 = context.getBuilder().authToken().build();
        OAuthToken authToken = testContext2.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)bearerToken.getId());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)authToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testAuthCodeIntrospectSelf() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().authToken().build();
        OAuthToken authToken = testContext.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)authToken.getId());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)authToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED, "access_denied");
    }

    @Test
    public void testRefreshTokenIntrospect() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = testContext.getToken();
        ApplicationBuilder.ApplicationContext testContext2 = context.getBuilder().refreshToken().build();
        OAuthToken refreshToken = testContext2.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)bearerToken.getId());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)refreshToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testRefreshTokenIntrospectSelf() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").refreshToken().build();
        OAuthToken refreshToken = testContext.getToken();
        String header = HttpUtil.authHeaderBearer((BigInteger)refreshToken.getId());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)refreshToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED, "access_denied");
    }

    @Test
    public void testExpiredBearerTokenIntrospect() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().client(ClientType.ClientCredentials, true).token(OAuthTokenType.Bearer, true, "debug", null, null).build();
        OAuthToken targetToken = testContext.getToken();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)targetToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)contextAuthHeader).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testExpiredAuthorizationTokenIntrospect() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().client(ClientType.ClientCredentials, true).token(OAuthTokenType.Authorization, true, "debug", null, null).build();
        OAuthToken targetToken = testContext.getToken();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)targetToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)contextAuthHeader).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testExpiredRefreshTokenIntrospect() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().client(ClientType.ClientCredentials, true).token(OAuthTokenType.Refresh, true, "debug", null, null).build();
        OAuthToken targetToken = testContext.getToken();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)targetToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)contextAuthHeader).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testNonexistentTokenIntrospect() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)IdUtil.next()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)contextAuthHeader).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testMalformedTokenIntrospect() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", "malformed_token");
        Response r = this.target("/introspect").request().header("Authorization", (Object)contextAuthHeader).post(this.buildEntity(values));
        this.assertErrorResponse(r, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testBearerTokenIntrospectByClientInHeader() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken targetToken = testContext.getToken();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)targetToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)contextAuthHeader).post(this.buildEntity(values));
        this.assertSuccessfulIntrospectionResponse(r, targetToken);
    }

    @Test
    public void testRefreshTokenIntrospectByClientInBody() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").refreshToken().build();
        OAuthToken targetToken = testContext.getToken();
        Client queryClient = testContext.getClient();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)targetToken.getId()));
        values.put("client_id", IdUtil.toString((BigInteger)queryClient.getId()));
        values.put("client_secret", queryClient.getClientSecret());
        Response r = this.target("/introspect").request().post(this.buildEntity(values));
        this.assertSuccessfulIntrospectionResponse(r, targetToken);
    }

    @Test
    public void testTokenIntrospectByApplicationPeerClientInBody() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").client(ClientType.ClientCredentials, true).build();
        OAuthToken targetToken = testContext.getToken();
        Client queryClient = testContext.getClient();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)targetToken.getId()));
        values.put("client_id", IdUtil.toString((BigInteger)queryClient.getId()));
        values.put("client_secret", queryClient.getClientSecret());
        Response r = this.target("/introspect").request().post(this.buildEntity(values));
        this.assertSuccessfulIntrospectionResponse(r, targetToken);
    }

    @Test
    public void testTokenIntrospectByApplicationPeerClientInHeader() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").client(ClientType.ClientCredentials, true).build();
        OAuthToken targetToken = testContext.getToken();
        Client queryClient = testContext.getClient();
        String header = HttpUtil.authHeaderBasic((BigInteger)queryClient.getId(), (String)queryClient.getClientSecret());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)targetToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertSuccessfulIntrospectionResponse(r, targetToken);
    }

    @Test
    public void testTokenIntrospectFromOtherApplicationInBody() {
        ApplicationBuilder.ApplicationContext tokenContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = tokenContext.getToken();
        Client queryClient = otherContext.getClient();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)bearerToken.getId()));
        values.put("client_id", IdUtil.toString((BigInteger)queryClient.getId()));
        values.put("client_secret", queryClient.getClientSecret());
        Response r = this.target("/introspect").request().post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testTokenIntrospectFromOtherApplicationInHeader() {
        ApplicationBuilder.ApplicationContext tokenContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = tokenContext.getToken();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)bearerToken.getId()));
        Response r = this.target("/introspect").request().header("Authorization", (Object)otherContextAuthHeader).post(this.buildEntity(values));
        this.assertInactiveIntrospectionResponse(r);
    }

    @Test
    public void testDualAuthPasses() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = testContext.getToken();
        Client queryClient = testContext.getClient();
        String header = HttpUtil.authHeaderBasic((BigInteger)queryClient.getId(), (String)queryClient.getClientSecret());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)bearerToken.getId()));
        values.put("client_id", IdUtil.toString((BigInteger)queryClient.getId()));
        values.put("client_secret", queryClient.getClientSecret());
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertSuccessfulIntrospectionResponse(r, bearerToken);
    }

    @Test
    public void testTokenAuthWithBodyClientAuth() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken("debug").build();
        OAuthToken bearerToken = testContext.getToken();
        Client queryClient = testContext.getClient();
        String header = HttpUtil.authHeaderBearer((BigInteger)bearerToken.getId());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("token", IdUtil.toString((BigInteger)bearerToken.getId()));
        values.put("client_id", IdUtil.toString((BigInteger)queryClient.getId()));
        values.put("client_secret", queryClient.getClientSecret());
        Response r = this.target("/introspect").request().header("Authorization", (Object)header).post(this.buildEntity(values));
        this.assertErrorResponse(r, Response.Status.UNAUTHORIZED, "access_denied");
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).scope("debug").scope("debug1").role("test", new String[]{"debug"}).client(ClientType.AuthorizationGrant, true).authenticator(AuthenticatorType.Test).redirect("http://www.example.com/").user().identity().claim("one", "claim").claim("two", "claim").build();
                otherContext = ApplicationBuilder.newApplication(session).scope("debug").scope("debug1").role("test", new String[]{"debug"}).client(ClientType.AuthorizationGrant, true).authenticator(AuthenticatorType.Test).redirect("http://www.example.com/").user().identity().claim("red", "claim").claim("blue", "claim").build();
                Client contextClient = context.getClient();
                contextAuthHeader = HttpUtil.authHeaderBasic((BigInteger)contextClient.getId(), (String)contextClient.getClientSecret());
                Client otherClient = otherContext.getClient();
                otherContextAuthHeader = HttpUtil.authHeaderBasic((BigInteger)otherClient.getId(), (String)otherClient.getClientSecret());
            }
        };
    }
}

