/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.rfc6749;

import java.math.BigInteger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.oauth2.rfc6749.AbstractRFC6749Test;
import net.krotscheck.kangaroo.authz.test.ApplicationBuilder;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.test.rule.TestDataResource;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;

public final class Section600RefreshTokenTest
extends AbstractRFC6749Test {
    private static ApplicationBuilder.ApplicationContext context;
    private static ApplicationBuilder.ApplicationContext authContext;
    private static String authHeader;
    @ClassRule
    public static final TestRule TEST_DATA_RULE;

    @Test
    public void testTokenSimpleRequest() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testAuthViaBodyRequest() {
        ApplicationBuilder.ApplicationContext testContext = authContext.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("client_secret", testContext.getClient().getClientSecret());
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testWrongAuthViaBodyRequest() {
        ApplicationBuilder.ApplicationContext testContext = authContext.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("client_secret", "wrong_secret");
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testAuthViaHeaderRequest() {
        ApplicationBuilder.ApplicationContext testContext = authContext.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testWrongAuthViaHeaderRequest() {
        ApplicationBuilder.ApplicationContext testContext = authContext.getBuilder().bearerToken().refreshToken().build();
        String badHeader = HttpUtil.authHeaderBasic((BigInteger)testContext.getClient().getId(), (String)"badsecret");
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)badHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testOnlyOneAuthMethod() {
        ApplicationBuilder.ApplicationContext testContext = authContext.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("client_secret", testContext.getClient().getClientSecret());
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertNull((Object)entity.getScope());
    }

    @Test
    public void testMismatchedClient() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testNoClientValidAuthContext() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().header("Authorization", (Object)authHeader).post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
    }

    @Test
    public void testNoClientMismatchAuthContext() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"access_denied", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testInvalidRefreshToken() {
        Client c = context.getClient();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)c.getId()));
        f.param("refresh_token", "invalid_token");
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"bad_request", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testExpiredRefreshToken() {
        ApplicationBuilder.ApplicationContext bridgeContext = context.getBuilder().bearerToken().build();
        ApplicationBuilder.ApplicationContext testContext = bridgeContext.getBuilder().token(OAuthTokenType.Bearer, true, null, null, bridgeContext.getToken()).build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    @Test
    public void testRefreshInvalidatedOnIssue() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertNull((Object)entity.getScope());
        Response r2 = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r2.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r2.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity2 = (ErrorResponseBuilder.ErrorResponse)r2.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_grant", (Object)entity2.getError());
        Assert.assertNotNull((Object)entity2.getErrorDescription());
    }

    @Test
    public void testScopePersistedOnRefresh() {
        ApplicationBuilder.ApplicationContext bridgeContext = context.getBuilder().bearerToken().build();
        ApplicationBuilder.ApplicationContext testContext = bridgeContext.getBuilder().token(OAuthTokenType.Refresh, false, "debug debug2", null, bridgeContext.getToken()).build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        f.param("scope", "debug debug2");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertEquals((Object)"debug debug2", (Object)entity.getScope());
    }

    @Test
    public void testScopeSubsetSelected() {
        ApplicationBuilder.ApplicationContext bridgeContext = context.getBuilder().bearerToken().build();
        ApplicationBuilder.ApplicationContext testContext = bridgeContext.getBuilder().token(OAuthTokenType.Refresh, false, "debug debug2", null, bridgeContext.getToken()).build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        f.param("scope", "debug2");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        TokenResponseEntity entity = (TokenResponseEntity)r.readEntity(TokenResponseEntity.class);
        this.assertValidBearerToken(entity, false);
        Assert.assertEquals((Object)"debug2", (Object)entity.getScope());
    }

    @Test
    public void testScopeEscalationFails() {
        ApplicationBuilder.ApplicationContext testContext = context.getBuilder().bearerToken().refreshToken().build();
        Form f = new Form();
        f.param("client_id", IdUtil.toString((BigInteger)testContext.getClient().getId()));
        f.param("refresh_token", IdUtil.toString((BigInteger)testContext.getToken().getId()));
        f.param("grant_type", "refresh_token");
        f.param("scope", "debug debug2");
        Entity postEntity = Entity.entity((Object)f, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Response r = this.target("/token").request().post(postEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)r.getMediaType());
        ErrorResponseBuilder.ErrorResponse entity = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"invalid_scope", (Object)entity.getError());
        Assert.assertNotNull((Object)entity.getErrorDescription());
    }

    static {
        TEST_DATA_RULE = new TestDataResource(HIBERNATE_RESOURCE){

            protected void loadTestData(Session session) {
                context = ApplicationBuilder.newApplication(session).scope("debug").scope("debug2").role("test", new String[]{"debug", "debug2"}).client(ClientType.AuthorizationGrant).authenticator(AuthenticatorType.Test).user().identity("test_identity_1").build();
                authContext = ApplicationBuilder.newApplication(session).scope("debug").scope("debug2").role("test", new String[]{"debug", "debug2"}).client(ClientType.OwnerCredentials, true).authenticator(AuthenticatorType.Test).user().identity("test_identity_2").build();
                authHeader = HttpUtil.authHeaderBasic((BigInteger)authContext.getClient().getId(), (String)authContext.getClient().getClientSecret());
            }
        };
    }
}

